/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.primitives.UnsignedLong;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendClientMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendHistoryMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendShardDataTreeSnapshotMetadata;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.MutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.UnsignedLongBitmap;

public class FrontendShardDataTreeSnapshotMetadataTest {
    @Test
    public void testCreateMetadataSnapshotNullInput() {
        Assert.assertThrows(NullPointerException.class, () -> new FrontendShardDataTreeSnapshotMetadata(null));
    }

    @Test
    public void testCreateMetadataSnapshotEmptyInput() throws Exception {
        FrontendShardDataTreeSnapshotMetadata emptyOrigSnapshot = FrontendShardDataTreeSnapshotMetadataTest.createEmptyMetadataSnapshot();
        FrontendShardDataTreeSnapshotMetadata emptyCopySnapshot = FrontendShardDataTreeSnapshotMetadataTest.copy(emptyOrigSnapshot, 86);
        FrontendShardDataTreeSnapshotMetadataTest.testMetadataSnapshotEqual(emptyOrigSnapshot, emptyCopySnapshot);
    }

    @Test
    public void testSerializeMetadataSnapshotWithOneClient() throws Exception {
        FrontendShardDataTreeSnapshotMetadata origSnapshot = FrontendShardDataTreeSnapshotMetadataTest.createMetadataSnapshot(1);
        FrontendShardDataTreeSnapshotMetadata copySnapshot = FrontendShardDataTreeSnapshotMetadataTest.copy(origSnapshot, 121);
        FrontendShardDataTreeSnapshotMetadataTest.testMetadataSnapshotEqual(origSnapshot, copySnapshot);
    }

    @Test
    public void testSerializeMetadataSnapshotWithMoreClients() throws Exception {
        FrontendShardDataTreeSnapshotMetadata origSnapshot = FrontendShardDataTreeSnapshotMetadataTest.createMetadataSnapshot(5);
        FrontendShardDataTreeSnapshotMetadata copySnapshot = FrontendShardDataTreeSnapshotMetadataTest.copy(origSnapshot, 273);
        FrontendShardDataTreeSnapshotMetadataTest.testMetadataSnapshotEqual(origSnapshot, copySnapshot);
    }

    private static void testMetadataSnapshotEqual(FrontendShardDataTreeSnapshotMetadata origSnapshot, FrontendShardDataTreeSnapshotMetadata copySnapshot) {
        List origClientList = origSnapshot.getClients();
        List copyClientList = copySnapshot.getClients();
        Assert.assertEquals((long)origClientList.size(), (long)copyClientList.size());
        HashMap origIdent = new HashMap();
        HashMap copyIdent = new HashMap();
        origClientList.forEach(client -> origIdent.put(client.getIdentifier(), client));
        origClientList.forEach(client -> copyIdent.put(client.getIdentifier(), client));
        Assert.assertTrue((boolean)origIdent.keySet().containsAll(copyIdent.keySet()));
        Assert.assertTrue((boolean)copyIdent.keySet().containsAll(origIdent.keySet()));
        origIdent.values().forEach(client -> {
            FrontendClientMetadata copyClient = (FrontendClientMetadata)copyIdent.get(client.getIdentifier());
            FrontendShardDataTreeSnapshotMetadataTest.testObject(client.getIdentifier(), copyClient.getIdentifier());
            Assert.assertEquals((Object)client.getPurgedHistories(), (Object)copyClient.getPurgedHistories());
            Assert.assertEquals((Object)client.getCurrentHistories(), (Object)copyClient.getCurrentHistories());
        });
    }

    private static FrontendShardDataTreeSnapshotMetadata createEmptyMetadataSnapshot() {
        return new FrontendShardDataTreeSnapshotMetadata(List.of());
    }

    private static FrontendShardDataTreeSnapshotMetadata createMetadataSnapshot(int size) {
        ArrayList<FrontendClientMetadata> clients = new ArrayList<FrontendClientMetadata>(size);
        for (long i = 0L; i < (long)size; ++i) {
            clients.add(FrontendShardDataTreeSnapshotMetadataTest.createFrontedClientMetadata(i));
        }
        return new FrontendShardDataTreeSnapshotMetadata(clients);
    }

    private static FrontendClientMetadata createFrontedClientMetadata(long num) {
        String index = String.valueOf(num);
        String indexName = "test_" + index;
        FrontendIdentifier frontendIdentifier = FrontendIdentifier.create((MemberName)MemberName.forName((String)indexName), (FrontendType)FrontendType.forName((String)index));
        ClientIdentifier clientIdentifier = ClientIdentifier.create((FrontendIdentifier)frontendIdentifier, (long)num);
        ImmutableUnsignedLongSet purgedHistories = MutableUnsignedLongSet.of((long[])new long[]{0L}).immutableCopy();
        return new FrontendClientMetadata(clientIdentifier, purgedHistories, List.of(new FrontendHistoryMetadata(num, num, true, UnsignedLongBitmap.copyOf(Map.of(UnsignedLong.ZERO, Boolean.TRUE)), purgedHistories)));
    }

    private static <T> void testObject(T object, T equalObject) {
        Assert.assertEquals((long)object.hashCode(), (long)equalObject.hashCode());
        Assert.assertTrue((boolean)object.equals(object));
        Assert.assertTrue((boolean)object.equals(equalObject));
        Assert.assertFalse((boolean)object.equals(null));
        Assert.assertFalse((boolean)object.equals("dummy"));
    }

    private static <T> T copy(T obj, int expectedSize) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(obj);
        }
        byte[] bytes = bos.toByteArray();
        Assert.assertEquals((long)expectedSize, (long)bytes.length);
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = ois.readObject();
            return (T)object;
        }
    }
}

