/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardstrategy;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ConfigurationImpl;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ModuleShardStrategy;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class ModuleShardStrategyTest {
    private static Configuration configuration;

    @BeforeClass
    public static void setUpClass() {
        configuration = new ConfigurationImpl("module-shards.conf", "modules.conf");
    }

    @Test
    public void testFindShard() {
        ModuleShardStrategy moduleShardStrategy = new ModuleShardStrategy("cars", configuration);
        String shard = moduleShardStrategy.findShard(CarsModel.BASE_PATH);
        Assert.assertEquals((Object)"cars-1", (Object)shard);
    }

    @Test
    public void testFindShardWhenModuleConfigurationPresentInModulesButMissingInModuleShards() {
        QName baseQName = QName.create((String)"urn:opendaylight:params:xml:ns:yang:controller:md:sal:dom:store:test:missing", (String)"2014-03-13", (String)"missing");
        YangInstanceIdentifier BASE_PATH = YangInstanceIdentifier.of((QName)baseQName);
        ModuleShardStrategy moduleShardStrategy = new ModuleShardStrategy("missing", configuration);
        String shard = moduleShardStrategy.findShard(BASE_PATH);
        Assert.assertEquals((Object)"default", (Object)shard);
    }
}

