/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardstrategy;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ConfigurationImpl;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ModuleShardStrategy;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategy;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategyFactory;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class ShardStrategyFactoryTest {
    private ShardStrategyFactory factory;

    @Before
    public void setUp() {
        this.factory = new ShardStrategyFactory((Configuration)new ConfigurationImpl("module-shards.conf", "modules.conf"));
    }

    @Test
    public void testGetStrategy() {
        ShardStrategy strategy = this.factory.getStrategy(TestModel.TEST_PATH);
        Assert.assertNotNull((Object)strategy);
    }

    @Test
    public void testGetStrategyForKnownModuleName() {
        ShardStrategy strategy = this.factory.getStrategy(YangInstanceIdentifier.of((QName)CarsModel.BASE_QNAME));
        Assert.assertTrue((boolean)(strategy instanceof ModuleShardStrategy));
    }

    @Test
    public void testGetStrategyNullPointerExceptionWhenPathIsNull() {
        NullPointerException ex = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.factory.getStrategy(null));
        Assert.assertEquals((Object)"path should not be null", (Object)ex.getMessage());
    }
}

