/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.base.VerifyException;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.UnsignedLong;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.datastore.utils.UnsignedLongBitmap;
import org.opendaylight.yangtools.concepts.WritableObjects;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class UnsignedLongBitmapTest {
    @Test
    public void testEmpty() throws IOException {
        UnsignedLongBitmap empty = UnsignedLongBitmap.of();
        Assert.assertTrue((boolean)empty.isEmpty());
        Assert.assertEquals((Object)empty, (Object)empty);
        Assert.assertSame((Object)empty, (Object)UnsignedLongBitmap.copyOf(Map.of()));
        Assert.assertEquals(Map.of(), (Object)empty.mutableCopy());
        Assert.assertEquals((Object)"{}", (Object)empty.toString());
        Assert.assertEquals((long)0L, (long)empty.hashCode());
        IOException ex = (IOException)Assert.assertThrows(IOException.class, () -> empty.writeEntriesTo((DataOutput)Mockito.mock(DataOutput.class), 1));
        Assert.assertEquals((Object)"Mismatched size: expected 0, got 1", (Object)ex.getMessage());
        empty.writeEntriesTo((DataOutput)Mockito.mock(DataOutput.class), 0);
        Assert.assertSame((Object)empty, (Object)UnsignedLongBitmapTest.assertWriteToReadFrom(empty));
    }

    @Test
    public void testSingleton() {
        UnsignedLongBitmap one = UnsignedLongBitmap.of((long)0L, (boolean)false);
        Assert.assertFalse((boolean)one.isEmpty());
        Assert.assertEquals((long)1L, (long)one.size());
        Assert.assertEquals((Object)one, (Object)one);
        Assert.assertEquals((Object)one, (Object)UnsignedLongBitmap.of((long)0L, (boolean)false));
        Assert.assertEquals((Object)one, (Object)UnsignedLongBitmap.copyOf(Map.of(UnsignedLong.ZERO, false)));
        Assert.assertEquals(Map.of(UnsignedLong.ZERO, false), (Object)one.mutableCopy());
        Assert.assertEquals((Object)"{0=false}", (Object)one.toString());
        Assert.assertEquals((long)1237L, (long)one.hashCode());
        IOException ex = (IOException)Assert.assertThrows(IOException.class, () -> one.writeEntriesTo((DataOutput)Mockito.mock(DataOutput.class), 0));
        Assert.assertEquals((Object)"Mismatched size: expected 1, got 0", (Object)ex.getMessage());
        Assert.assertEquals((Object)one, (Object)UnsignedLongBitmap.of((long)0L, (boolean)false));
        Assert.assertNotEquals((Object)one, (Object)UnsignedLongBitmap.of((long)0L, (boolean)true));
        Assert.assertNotEquals((Object)one, (Object)UnsignedLongBitmap.of((long)1L, (boolean)false));
        Assert.assertNotEquals((Object)UnsignedLongBitmap.of(), (Object)one);
        Assert.assertNotEquals((Object)one, (Object)UnsignedLongBitmap.of());
        UnsignedLongBitmapTest.assertWriteToReadFrom(one);
    }

    @Test
    public void testRegular() {
        UnsignedLongBitmap one = UnsignedLongBitmap.copyOf(Map.of(UnsignedLong.ZERO, false, UnsignedLong.ONE, true));
        Assert.assertFalse((boolean)one.isEmpty());
        Assert.assertEquals((long)2L, (long)one.size());
        Assert.assertEquals((Object)one, (Object)one);
        Assert.assertEquals((Object)one, (Object)UnsignedLongBitmap.copyOf(Map.of(UnsignedLong.ONE, true, UnsignedLong.ZERO, false)));
        Assert.assertEquals(Map.of(UnsignedLong.ZERO, false, UnsignedLong.ONE, true), (Object)one.mutableCopy());
        Assert.assertNotEquals((Object)one, (Object)UnsignedLongBitmap.copyOf(Map.of(UnsignedLong.ZERO, false, UnsignedLong.valueOf((long)2L), true)));
        Assert.assertEquals((Object)"{0=false, 1=true}", (Object)one.toString());
        Assert.assertEquals((long)40345L, (long)one.hashCode());
        IOException ex = (IOException)Assert.assertThrows(IOException.class, () -> one.writeEntriesTo((DataOutput)Mockito.mock(DataOutput.class), 1));
        Assert.assertEquals((Object)"Mismatched size: expected 2, got 1", (Object)ex.getMessage());
        UnsignedLongBitmap two = UnsignedLongBitmap.copyOf(Map.of(UnsignedLong.ZERO, true, UnsignedLong.ONE, false));
        Assert.assertFalse((boolean)two.isEmpty());
        Assert.assertEquals((long)2L, (long)two.size());
        Assert.assertEquals((Object)two, (Object)two);
        Assert.assertEquals((Object)two, (Object)UnsignedLongBitmap.copyOf(Map.of(UnsignedLong.ZERO, true, UnsignedLong.ONE, false)));
        Assert.assertEquals((Object)"{0=true, 1=false}", (Object)two.toString());
        Assert.assertEquals((long)40549L, (long)two.hashCode());
        Assert.assertNotEquals((Object)one, (Object)two);
        Assert.assertNotEquals((Object)two, (Object)one);
        UnsignedLongBitmapTest.assertWriteToReadFrom(one);
        UnsignedLongBitmapTest.assertWriteToReadFrom(two);
    }

    private static UnsignedLongBitmap assertWriteToReadFrom(UnsignedLongBitmap orig) {
        UnsignedLongBitmap copy;
        ByteArrayDataOutput dos = ByteStreams.newDataOutput();
        try {
            orig.writeEntriesTo((DataOutput)dos);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        try {
            ByteArrayDataInput dis = ByteStreams.newDataInput((byte[])dos.toByteArray());
            copy = UnsignedLongBitmap.readFrom((DataInput)dis, (int)orig.size());
            Assert.assertThrows(IllegalStateException.class, () -> dis.readByte());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        Assert.assertEquals((Object)orig, (Object)copy);
        return copy;
    }

    @Test
    public void testKeyOrder() throws IOException {
        UnsignedLongBitmapTest.assertInvalidKey(0L);
        UnsignedLongBitmapTest.assertInvalidKey(1L);
    }

    private static void assertInvalidKey(long second) throws IOException {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        WritableObjects.writeLong((DataOutput)out, (long)1L);
        out.writeBoolean(false);
        WritableObjects.writeLong((DataOutput)out, (long)second);
        out.writeBoolean(true);
        IOException ex = (IOException)Assert.assertThrows(IOException.class, () -> UnsignedLongBitmap.readFrom((DataInput)ByteStreams.newDataInput((byte[])out.toByteArray()), (int)2));
        Assert.assertEquals((Object)("Key " + second + " may not be used after key 1"), (Object)ex.getMessage());
    }

    @Test
    public void testInvalidArrays() {
        Assert.assertThrows(VerifyException.class, () -> new UnsignedLongBitmap.Regular(new long[0], new boolean[]{false, false}));
    }
}

