/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.cluster.datastore.model;

import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.test.util.YangParserTestUtils;

public final class TestModel {
    public static final QName TEST_QNAME = QName.create((String)"urn:opendaylight:params:xml:ns:yang:controller:md:sal:dom:store:test", (String)"2014-03-13", (String)"test");
    public static final QName TEST2_QNAME = QName.create((String)"urn:opendaylight:params:xml:ns:yang:controller:md:sal:dom:store:test", (String)"2014-03-13", (String)"test2");
    public static final QName JUNK_QNAME = QName.create((String)"urn:opendaylight:params:xml:ns:yang:controller:md:sal:dom:store:junk", (String)"2014-03-13", (String)"junk");
    public static final QName OUTER_LIST_QNAME = QName.create((QName)TEST_QNAME, (String)"outer-list");
    public static final QName OUTER_CONTAINER_QNAME = QName.create((QName)TEST_QNAME, (String)"outer-container");
    public static final QName INNER_LIST_QNAME = QName.create((QName)TEST_QNAME, (String)"inner-list");
    public static final QName OUTER_CHOICE_QNAME = QName.create((QName)TEST_QNAME, (String)"outer-choice");
    public static final QName ID_QNAME = QName.create((QName)TEST_QNAME, (String)"id");
    public static final QName NAME_QNAME = QName.create((QName)TEST_QNAME, (String)"name");
    public static final QName VALUE_QNAME = QName.create((QName)TEST_QNAME, (String)"value");
    public static final QName DESC_QNAME = QName.create((QName)TEST_QNAME, (String)"desc");
    private static final String DATASTORE_TEST_YANG = "/odl-datastore-test.yang";
    public static final YangInstanceIdentifier TEST_PATH = YangInstanceIdentifier.of((QName)TEST_QNAME);
    public static final YangInstanceIdentifier TEST2_PATH = YangInstanceIdentifier.of((QName)TEST2_QNAME);
    public static final YangInstanceIdentifier JUNK_PATH = YangInstanceIdentifier.of((QName)JUNK_QNAME);
    public static final YangInstanceIdentifier OUTER_LIST_PATH = YangInstanceIdentifier.builder((YangInstanceIdentifier)TEST_PATH).node(OUTER_LIST_QNAME).build();
    public static final YangInstanceIdentifier INNER_LIST_PATH = YangInstanceIdentifier.builder((YangInstanceIdentifier)TEST_PATH).node(OUTER_LIST_QNAME).node(INNER_LIST_QNAME).build();
    public static final YangInstanceIdentifier OUTER_CONTAINER_PATH = TEST_PATH.node(OUTER_CONTAINER_QNAME);
    public static final QName TWO_QNAME = QName.create((QName)TEST_QNAME, (String)"two");
    public static final QName THREE_QNAME = QName.create((QName)TEST_QNAME, (String)"three");

    private TestModel() {
    }

    public static EffectiveModelContext createTestContext() {
        return YangParserTestUtils.parseYangResource((String)DATASTORE_TEST_YANG);
    }

    public static DataContainerChild outerMapNode() {
        return (DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)OUTER_LIST_QNAME).build();
    }

    public static DataContainerChild outerNode(int ... ids) {
        CollectionNodeBuilder outer = ImmutableNodes.mapNodeBuilder((QName)OUTER_LIST_QNAME);
        for (int id : ids) {
            outer.addChild((NormalizedNode)ImmutableNodes.mapEntry((QName)OUTER_LIST_QNAME, (QName)ID_QNAME, (Object)id));
        }
        return (DataContainerChild)outer.build();
    }

    public static DataContainerChild outerNode(MapEntryNode ... entries) {
        CollectionNodeBuilder outer = ImmutableNodes.mapNodeBuilder((QName)OUTER_LIST_QNAME);
        for (MapEntryNode e : entries) {
            outer.addChild((NormalizedNode)e);
        }
        return (DataContainerChild)outer.build();
    }

    public static DataContainerChild innerNode(String ... names) {
        CollectionNodeBuilder outer = ImmutableNodes.mapNodeBuilder((QName)INNER_LIST_QNAME);
        for (String name : names) {
            outer.addChild((NormalizedNode)ImmutableNodes.mapEntry((QName)INNER_LIST_QNAME, (QName)NAME_QNAME, (Object)name));
        }
        return (DataContainerChild)outer.build();
    }

    public static MapEntryNode outerNodeEntry(int id, DataContainerChild inner) {
        return (MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)OUTER_LIST_QNAME, (QName)ID_QNAME, (Object)id).addChild((NormalizedNode)inner).build();
    }

    public static ContainerNode testNodeWithOuter(int ... ids) {
        return TestModel.testNodeWithOuter(TestModel.outerNode(ids));
    }

    public static ContainerNode testNodeWithOuter(DataContainerChild outer) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TEST_QNAME)).withChild(outer).build();
    }

    public static YangInstanceIdentifier.NodeIdentifierWithPredicates outerEntryKey(int id) {
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)OUTER_LIST_QNAME, (QName)ID_QNAME, (Object)id);
    }

    public static YangInstanceIdentifier outerEntryPath(int id) {
        return OUTER_LIST_PATH.node((YangInstanceIdentifier.PathArgument)TestModel.outerEntryKey(id));
    }

    public static YangInstanceIdentifier.NodeIdentifierWithPredicates innerEntryKey(String name) {
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)INNER_LIST_QNAME, (QName)NAME_QNAME, (Object)name);
    }

    public static YangInstanceIdentifier innerEntryPath(int id, String name) {
        return OUTER_LIST_PATH.node((YangInstanceIdentifier.PathArgument)TestModel.outerEntryKey(id)).node(INNER_LIST_QNAME).node((YangInstanceIdentifier.PathArgument)TestModel.innerEntryKey(name));
    }

    public static YangInstanceIdentifier innerMapPath(int id) {
        return OUTER_LIST_PATH.node((YangInstanceIdentifier.PathArgument)TestModel.outerEntryKey(id)).node(INNER_LIST_QNAME);
    }
}

