/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.databroker.ClientBackedReadTransaction;
import org.opendaylight.controller.cluster.databroker.ClientBackedTransactionTest;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ClientBackedReadTransactionTest
extends ClientBackedTransactionTest<ClientBackedReadTransaction> {
    private ClientBackedReadTransaction object;
    @Mock
    private ContainerNode data;
    @Mock
    private ClientActorContext clientContext;
    @Mock
    private ClientSnapshot delegate;

    @Override
    ClientBackedReadTransaction object() {
        return this.object;
    }

    @Before
    public void setUp() {
        ((ClientSnapshot)Mockito.doReturn((Object)TRANSACTION_ID).when((Object)this.delegate)).getIdentifier();
        ((ClientSnapshot)Mockito.doReturn((Object)FluentFutures.immediateTrueFluentFuture()).when((Object)this.delegate)).exists(YangInstanceIdentifier.of());
        ((ClientSnapshot)Mockito.doReturn((Object)FluentFutures.immediateFluentFuture(Optional.of(this.data))).when((Object)this.delegate)).read(YangInstanceIdentifier.of());
        this.object = new ClientBackedReadTransaction(this.delegate, null, null);
    }

    @Test
    public void testRead() throws Exception {
        Assert.assertEquals(Optional.of(this.data), (Object)this.object().read(YangInstanceIdentifier.of()).get());
    }

    @Test
    public void testExists() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.object().exists(YangInstanceIdentifier.of()).get());
    }
}

