/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Status;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.commands.ConnectClientFailure;
import org.opendaylight.controller.cluster.access.commands.ConnectClientRequest;
import org.opendaylight.controller.cluster.access.commands.ConnectClientSuccess;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RuntimeRequestException;
import org.opendaylight.controller.cluster.databroker.actors.dds.ModuleShardBackendResolver;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.shardmanager.RegisterForShardAvailabilityChanges;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategy;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategyFactory;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.PrimaryShardInfoFutureCache;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.ReadOnlyDataTree;
import scala.concurrent.impl.Promise;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ModuleShardBackendResolverTest {
    private static final MemberName MEMBER_NAME = MemberName.forName((String)"member-1");
    private static final FrontendType FRONTEND_TYPE = FrontendType.forName((String)"type-1");
    private static final FrontendIdentifier FRONTEND_ID = FrontendIdentifier.create((MemberName)MEMBER_NAME, (FrontendType)FRONTEND_TYPE);
    private static final ClientIdentifier CLIENT_ID = ClientIdentifier.create((FrontendIdentifier)FRONTEND_ID, (long)0L);
    private ActorSystem system;
    private ModuleShardBackendResolver moduleShardBackendResolver;
    private TestProbe contextProbe;
    private TestProbe shardManagerProbe;
    @Mock
    private ShardStrategyFactory shardStrategyFactory;
    @Mock
    private ShardStrategy shardStrategy;
    @Mock
    private DataTree dataTree;

    @Before
    public void setUp() {
        this.system = ActorSystem.apply();
        this.contextProbe = new TestProbe(this.system, "context");
        this.shardManagerProbe = new TestProbe(this.system, "ShardManager");
        ActorUtils actorUtils = ModuleShardBackendResolverTest.createActorUtilsMock(this.system, this.contextProbe.ref());
        ((ActorUtils)Mockito.doReturn((Object)this.shardManagerProbe.ref()).when((Object)actorUtils)).getShardManager();
        this.moduleShardBackendResolver = new ModuleShardBackendResolver(CLIENT_ID, actorUtils);
        ((ActorUtils)Mockito.doReturn((Object)this.shardStrategyFactory).when((Object)actorUtils)).getShardStrategyFactory();
        ((ShardStrategyFactory)Mockito.doReturn((Object)this.shardStrategy).when((Object)this.shardStrategyFactory)).getStrategy(YangInstanceIdentifier.of());
        PrimaryShardInfoFutureCache cache = new PrimaryShardInfoFutureCache();
        ((ActorUtils)Mockito.doReturn((Object)cache).when((Object)actorUtils)).getPrimaryShardInfoCache();
    }

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }

    @Test
    public void testResolveShardForPathNonNullCookie() {
        ((ShardStrategy)Mockito.doReturn((Object)"default").when((Object)this.shardStrategy)).findShard(YangInstanceIdentifier.of());
        Long cookie = this.moduleShardBackendResolver.resolveShardForPath(YangInstanceIdentifier.of());
        Assert.assertEquals((long)0L, (long)cookie);
    }

    @Test
    public void testResolveShardForPathNullCookie() {
        ((ShardStrategy)Mockito.doReturn((Object)"foo").when((Object)this.shardStrategy)).findShard(YangInstanceIdentifier.of());
        Long cookie = this.moduleShardBackendResolver.resolveShardForPath(YangInstanceIdentifier.of());
        Assert.assertEquals((long)1L, (long)cookie);
    }

    @Test
    public void testGetBackendInfo() throws Exception {
        CompletionStage i = this.moduleShardBackendResolver.getBackendInfo(Long.valueOf(0L));
        this.contextProbe.expectMsgClass(ConnectClientRequest.class);
        TestProbe backendProbe = new TestProbe(this.system, "backend");
        ConnectClientSuccess msg = new ConnectClientSuccess(CLIENT_ID, 0L, backendProbe.ref(), List.of(), (ReadOnlyDataTree)this.dataTree, 3);
        this.contextProbe.reply((Object)msg);
        CompletionStage stage = this.moduleShardBackendResolver.getBackendInfo(Long.valueOf(0L));
        ShardBackendInfo shardBackendInfo = (ShardBackendInfo)TestUtils.getWithTimeout(stage.toCompletableFuture());
        Assert.assertEquals((long)0L, (long)shardBackendInfo.getCookie().longValue());
        Assert.assertEquals((Object)this.dataTree, shardBackendInfo.getDataTree().orElseThrow());
        Assert.assertEquals((Object)"default", (Object)shardBackendInfo.getName());
    }

    @Test
    public void testGetBackendInfoFail() throws Exception {
        CompletionStage i = this.moduleShardBackendResolver.getBackendInfo(Long.valueOf(0L));
        ConnectClientRequest req = (ConnectClientRequest)this.contextProbe.expectMsgClass(ConnectClientRequest.class);
        RuntimeException cause = new RuntimeException();
        ConnectClientFailure response = req.toRequestFailure((RequestException)new RuntimeRequestException("fail", (Throwable)cause));
        this.contextProbe.reply((Object)response);
        CompletionStage stage = this.moduleShardBackendResolver.getBackendInfo(Long.valueOf(0L));
        ExecutionException caught = TestUtils.assertOperationThrowsException(() -> TestUtils.getWithTimeout(stage.toCompletableFuture()), ExecutionException.class);
        Assert.assertEquals((Object)cause, (Object)caught.getCause());
    }

    @Test
    public void testRefreshBackendInfo() throws Exception {
        CompletionStage backendInfo = this.moduleShardBackendResolver.getBackendInfo(Long.valueOf(0L));
        this.contextProbe.expectMsgClass(ConnectClientRequest.class);
        TestProbe staleBackendProbe = new TestProbe(this.system, "staleBackend");
        ConnectClientSuccess msg = new ConnectClientSuccess(CLIENT_ID, 0L, staleBackendProbe.ref(), List.of(), (ReadOnlyDataTree)this.dataTree, 3);
        this.contextProbe.reply((Object)msg);
        ShardBackendInfo staleBackendInfo = (ShardBackendInfo)TestUtils.getWithTimeout(backendInfo.toCompletableFuture());
        CompletionStage refreshed = this.moduleShardBackendResolver.refreshBackendInfo(Long.valueOf(0L), staleBackendInfo);
        this.contextProbe.expectMsgClass(ConnectClientRequest.class);
        TestProbe refreshedBackendProbe = new TestProbe(this.system, "refreshedBackend");
        ConnectClientSuccess msg2 = new ConnectClientSuccess(CLIENT_ID, 1L, refreshedBackendProbe.ref(), List.of(), (ReadOnlyDataTree)this.dataTree, 3);
        this.contextProbe.reply((Object)msg2);
        ShardBackendInfo refreshedBackendInfo = (ShardBackendInfo)TestUtils.getWithTimeout(refreshed.toCompletableFuture());
        Assert.assertEquals((Object)staleBackendInfo.getCookie(), (Object)refreshedBackendInfo.getCookie());
        Assert.assertEquals((Object)refreshedBackendProbe.ref(), (Object)refreshedBackendInfo.getActor());
    }

    @Test
    public void testNotifyWhenBackendInfoIsStale() {
        RegisterForShardAvailabilityChanges regMessage = (RegisterForShardAvailabilityChanges)this.shardManagerProbe.expectMsgClass(RegisterForShardAvailabilityChanges.class);
        Registration mockReg = (Registration)Mockito.mock(Registration.class);
        this.shardManagerProbe.reply((Object)new Status.Success((Object)mockReg));
        Consumer mockCallback = (Consumer)Mockito.mock(Consumer.class);
        Registration callbackReg = this.moduleShardBackendResolver.notifyWhenBackendInfoIsStale(mockCallback);
        regMessage.getCallback().accept("default");
        ((Consumer)Mockito.verify((Object)mockCallback, (VerificationMode)Mockito.timeout((long)5000L))).accept(0L);
        Mockito.reset((Object[])new Consumer[]{mockCallback});
        callbackReg.close();
        regMessage.getCallback().accept("default");
        Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockCallback});
    }

    private static ActorUtils createActorUtilsMock(ActorSystem system, ActorRef actor) {
        ActorUtils mock = (ActorUtils)Mockito.mock(ActorUtils.class);
        Promise.DefaultPromise promise = new Promise.DefaultPromise();
        ActorSelection selection = system.actorSelection(actor.path());
        PrimaryShardInfo shardInfo = new PrimaryShardInfo(selection, 0);
        promise.success((Object)shardInfo);
        ((ActorUtils)Mockito.doReturn((Object)promise.future()).when((Object)mock)).findPrimaryShardAsync("default");
        return mock;
    }
}

