/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.testkit.TestProbe;
import org.eclipse.jdt.annotation.NonNull;
import org.junit.Assert;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.commands.TransactionFailure;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.FailureEnvelope;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.controller.cluster.access.concepts.SuccessEnvelope;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

class TransactionTester<T extends AbstractProxyTransaction> {
    private final T transaction;
    private final AbstractClientConnection<ShardBackendInfo> connection;
    private final TestProbe backendProbe;
    private RequestEnvelope envelope;

    TransactionTester(T transaction, AbstractClientConnection<ShardBackendInfo> connection, TestProbe backendProbe) {
        this.transaction = transaction;
        this.connection = connection;
        this.backendProbe = backendProbe;
    }

    ActorRef localActor() {
        return this.connection.localActor();
    }

    T getTransaction() {
        return this.transaction;
    }

    TransactionRequest<?> getLastReceivedMessage() {
        return (TransactionRequest)this.envelope.getMessage();
    }

    <R extends TransactionRequest<R>> R expectTransactionRequest(Class<R> expected) {
        this.envelope = (RequestEnvelope)this.backendProbe.expectMsgClass(RequestEnvelope.class);
        Class<?> actual = ((Request)this.envelope.getMessage()).getClass();
        String errorMsg = String.format("Expected instance of %s, received %s", expected, actual);
        Assert.assertTrue((String)errorMsg, (boolean)expected.isAssignableFrom(actual));
        return (R)((TransactionRequest)expected.cast(this.envelope.getMessage()));
    }

    void replySuccess(RequestSuccess<?, ?> success) {
        long sessionId = this.envelope.getSessionId();
        long txSequence = this.envelope.getTxSequence();
        long executionTime = 0L;
        SuccessEnvelope responseEnvelope = new SuccessEnvelope(success, sessionId, txSequence, 0L);
        AccessClientUtil.completeRequest(this.connection, (ResponseEnvelope)responseEnvelope);
    }

    void replyFailure(RequestException cause) {
        long sessionId = this.envelope.getSessionId();
        long txSequence = this.envelope.getTxSequence();
        long executionTime = 0L;
        MockFailure fail = new MockFailure((TransactionIdentifier)this.transaction.getIdentifier(), ((Request)this.envelope.getMessage()).getSequence(), cause);
        FailureEnvelope responseEnvelope = new FailureEnvelope((RequestFailure)fail, sessionId, txSequence, 0L);
        AccessClientUtil.completeRequest(this.connection, (ResponseEnvelope)responseEnvelope);
    }

    private static class MockFailure
    extends RequestFailure<TransactionIdentifier, TransactionFailure> {
        private static final long serialVersionUID = 1L;

        MockFailure(@NonNull TransactionIdentifier target, long sequence, @NonNull RequestException cause) {
            super((WritableIdentifier)target, sequence, cause);
        }

        protected TransactionFailure cloneAsVersion(ABIVersion targetVersion) {
            throw new UnsupportedOperationException("Not implemented");
        }

        protected RequestFailure.SerialForm<TransactionIdentifier, TransactionFailure> externalizableProxy(ABIVersion version) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

