/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.client.RequestTimeoutException;
import org.opendaylight.controller.cluster.databroker.ClientBackedDataStore;
import org.opendaylight.controller.cluster.databroker.ConcurrentDOMDataBroker;
import org.opendaylight.controller.cluster.datastore.AbstractShardTest;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.IntegrationTestKit;
import org.opendaylight.controller.cluster.datastore.TestShard;
import org.opendaylight.controller.cluster.datastore.messages.FindLocalShard;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardFound;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendClientMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendHistoryMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendShardDataTreeSnapshotMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.datastore.utils.MockDataTreeChangeListener;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.opendaylight.controller.cluster.raft.utils.InMemorySnapshotStore;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.PeopleModel;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainClosedException;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.impl.di.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public abstract class AbstractDistributedDataStoreIntegrationTest {
    @Parameterized.Parameter
    public Class<? extends ClientBackedDataStore> testParameter;
    protected ActorSystem system;
    protected final DatastoreContext.Builder datastoreContextBuilder = DatastoreContext.newBuilder().shardHeartbeatIntervalInMillis(100);

    protected ActorSystem getSystem() {
        return this.system;
    }

    @Test
    public void testWriteTransactionWithSingleShard() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "transactionIntegrationTest", "test-1");){
            testKit.testWriteTransaction(dataStore, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
            testKit.testWriteTransaction(dataStore, TestModel.OUTER_LIST_PATH, ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).withChild((NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)42)).build());
        }
    }

    @Test
    public void testWriteTransactionWithMultipleShards() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testWriteTransactionWithMultipleShards", "cars-1", "people-1");){
            DOMStoreWriteTransaction writeTx = dataStore.newWriteOnlyTransaction();
            Assert.assertNotNull((String)"newWriteOnlyTransaction returned null", (Object)writeTx);
            writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
            writeTx.write(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.emptyContainer());
            testKit.doCommit(writeTx.ready());
            writeTx = dataStore.newWriteOnlyTransaction();
            writeTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
            writeTx.write(PeopleModel.PERSON_LIST_PATH, (NormalizedNode)PeopleModel.newPersonMapNode());
            testKit.doCommit(writeTx.ready());
            writeTx = dataStore.newWriteOnlyTransaction();
            MapEntryNode car = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
            YangInstanceIdentifier carPath = CarsModel.newCarPath("optima");
            writeTx.write(carPath, (NormalizedNode)car);
            MapEntryNode person = PeopleModel.newPersonEntry("jack");
            YangInstanceIdentifier personPath = PeopleModel.newPersonPath("jack");
            writeTx.write(personPath, (NormalizedNode)person);
            testKit.doCommit(writeTx.ready());
            DOMStoreReadTransaction readTx = dataStore.newReadOnlyTransaction();
            Assert.assertEquals(Optional.of(car), (Object)readTx.read(carPath).get(5L, TimeUnit.SECONDS));
            Assert.assertEquals(Optional.of(person), (Object)readTx.read(personPath).get(5L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testReadWriteTransactionWithSingleShard() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testReadWriteTransactionWithSingleShard", "test-1");){
            DOMStoreReadWriteTransaction readWriteTx = dataStore.newReadWriteTransaction();
            Assert.assertNotNull((String)"newReadWriteTransaction returned null", (Object)readWriteTx);
            YangInstanceIdentifier nodePath = TestModel.TEST_PATH;
            ContainerNode nodeToWrite = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            readWriteTx.write(nodePath, (NormalizedNode)nodeToWrite);
            Boolean exists = (Boolean)readWriteTx.exists(nodePath).get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"exists", (Object)Boolean.TRUE, (Object)exists);
            Assert.assertEquals(Optional.of(nodeToWrite), (Object)readWriteTx.read(nodePath).get(5L, TimeUnit.SECONDS));
            DOMStoreThreePhaseCommitCohort cohort = readWriteTx.ready();
            testKit.doCommit(cohort);
            DOMStoreReadTransaction readTx = dataStore.newReadOnlyTransaction();
            Assert.assertEquals(Optional.of(nodeToWrite), (Object)readTx.read(nodePath).get(5L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testReadWriteTransactionWithMultipleShards() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testReadWriteTransactionWithMultipleShards", "cars-1", "people-1");){
            DOMStoreReadWriteTransaction readWriteTx = dataStore.newReadWriteTransaction();
            Assert.assertNotNull((String)"newReadWriteTransaction returned null", (Object)readWriteTx);
            readWriteTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
            readWriteTx.write(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.emptyContainer());
            testKit.doCommit(readWriteTx.ready());
            readWriteTx = dataStore.newReadWriteTransaction();
            readWriteTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
            readWriteTx.write(PeopleModel.PERSON_LIST_PATH, (NormalizedNode)PeopleModel.newPersonMapNode());
            testKit.doCommit(readWriteTx.ready());
            readWriteTx = dataStore.newReadWriteTransaction();
            MapEntryNode car = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
            YangInstanceIdentifier carPath = CarsModel.newCarPath("optima");
            readWriteTx.write(carPath, (NormalizedNode)car);
            MapEntryNode person = PeopleModel.newPersonEntry("jack");
            YangInstanceIdentifier personPath = PeopleModel.newPersonPath("jack");
            readWriteTx.write(personPath, (NormalizedNode)person);
            Boolean exists = (Boolean)readWriteTx.exists(carPath).get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)"exists", (Object)Boolean.TRUE, (Object)exists);
            Assert.assertEquals((String)"Data node", Optional.of(car), (Object)readWriteTx.read(carPath).get(5L, TimeUnit.SECONDS));
            testKit.doCommit(readWriteTx.ready());
            DOMStoreReadTransaction readTx = dataStore.newReadOnlyTransaction();
            Assert.assertEquals(Optional.of(car), (Object)readTx.read(carPath).get(5L, TimeUnit.SECONDS));
            Assert.assertEquals(Optional.of(person), (Object)readTx.read(personPath).get(5L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testSingleTransactionsWritesInQuickSuccession() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testSingleTransactionsWritesInQuickSuccession", "cars-1");){
            DOMStoreTransactionChain txChain = dataStore.createTransactionChain();
            DOMStoreWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
            writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
            writeTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
            testKit.doCommit(writeTx.ready());
            int numCars = 5;
            for (int i = 0; i < numCars; ++i) {
                writeTx = txChain.newWriteOnlyTransaction();
                writeTx.write(CarsModel.newCarPath("car" + i), (NormalizedNode)CarsModel.newCarEntry("car" + i, Uint64.valueOf((int)20000)));
                testKit.doCommit(writeTx.ready());
                try (DOMStoreReadTransaction tx = txChain.newReadOnlyTransaction();){
                    tx.read(CarsModel.BASE_PATH).get();
                    continue;
                }
            }
            Awaitility.await((String)"transaction state propagation").atMost(5L, TimeUnit.SECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).untilAsserted(() -> {
                ActorRef localShard = (ActorRef)dataStore.getActorUtils().findLocalShard("cars-1").orElseThrow();
                FrontendShardDataTreeSnapshotMetadata frontendMetadata = (FrontendShardDataTreeSnapshotMetadata)dataStore.getActorUtils().executeOperation(localShard, (Object)new TestShard.RequestFrontendMetadata());
                FrontendClientMetadata clientMeta = (FrontendClientMetadata)frontendMetadata.getClients().get(0);
                UnmodifiableIterator iterator = clientMeta.getCurrentHistories().iterator();
                FrontendHistoryMetadata metadata = (FrontendHistoryMetadata)iterator.next();
                while (iterator.hasNext() && metadata.getHistoryId() != 1L) {
                    metadata = (FrontendHistoryMetadata)iterator.next();
                }
                Assert.assertEquals((Object)"[[0..10]]", (Object)metadata.getPurgedTransactions().ranges().toString());
            });
            Object body = ((NormalizedNode)((Optional)txChain.newReadOnlyTransaction().read(CarsModel.CAR_LIST_PATH).get(5L, TimeUnit.SECONDS)).orElseThrow()).body();
            MatcherAssert.assertThat((Object)body, (Matcher)CoreMatchers.instanceOf(Collection.class));
            Assert.assertEquals((String)"# cars", (long)numCars, (long)((Collection)body).size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTransactionCommitFailureWithNoShardLeader(boolean writeOnly, String testName) throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        String shardName = "default";
        this.datastoreContextBuilder.customRaftPolicyImplementation("org.opendaylight.controller.cluster.raft.policy.DisableElectionsRaftPolicy");
        this.datastoreContextBuilder.shardHeartbeatIntervalInMillis(100).shardElectionTimeoutFactor(1L).shardInitializationTimeout(200L, TimeUnit.MILLISECONDS).frontendRequestTimeoutInSeconds(2L);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, testName, false, "default");){
            Object result = dataStore.getActorUtils().executeOperation(dataStore.getActorUtils().getShardManager(), (Object)new FindLocalShard("default", true));
            Assert.assertTrue((String)("Expected LocalShardFound. Actual: " + result), (boolean)(result instanceof LocalShardFound));
            DOMStoreWriteTransaction writeTxToClose = null;
            try {
                DOMStoreWriteTransaction writeTx = writeTxToClose = writeOnly ? dataStore.newWriteOnlyTransaction() : dataStore.newReadWriteTransaction();
                Assert.assertNotNull((String)"newReadWriteTransaction returned null", (Object)writeTx);
                AtomicReference txCohort = new AtomicReference();
                AtomicReference caughtEx = new AtomicReference();
                CountDownLatch txReady = new CountDownLatch(1);
                Thread txThread = new Thread(() -> {
                    try {
                        writeTx.write(TestModel.JUNK_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.JUNK_QNAME));
                        txCohort.set(writeTx.ready());
                    }
                    catch (Exception e) {
                        caughtEx.set(e);
                    }
                    finally {
                        txReady.countDown();
                    }
                });
                txThread.start();
                boolean done = Uninterruptibles.awaitUninterruptibly((CountDownLatch)txReady, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                if (caughtEx.get() != null) {
                    throw (Exception)caughtEx.get();
                }
                Assert.assertTrue((String)"Tx ready", (boolean)done);
                ExecutionException ex = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ((DOMStoreThreePhaseCommitCohort)txCohort.get()).canCommit().get(10L, TimeUnit.SECONDS));
                Assert.assertTrue((String)("Unexpected exception: " + Throwables.getStackTraceAsString((Throwable)ex.getCause())), (boolean)(Throwables.getRootCause((Throwable)ex) instanceof RequestTimeoutException));
            }
            finally {
                try {
                    if (writeTxToClose != null) {
                        writeTxToClose.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @Test
    public void testWriteOnlyTransactionCommitFailureWithNoShardLeader() throws Exception {
        this.datastoreContextBuilder.writeOnlyTransactionOptimizationsEnabled(true);
        this.testTransactionCommitFailureWithNoShardLeader(true, "testWriteOnlyTransactionCommitFailureWithNoShardLeader");
    }

    @Test
    public void testReadWriteTransactionCommitFailureWithNoShardLeader() throws Exception {
        this.testTransactionCommitFailureWithNoShardLeader(false, "testReadWriteTransactionCommitFailureWithNoShardLeader");
    }

    @Test
    public void testTransactionAbort() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "transactionAbortIntegrationTest", "test-1");){
            DOMStoreWriteTransaction writeTx = dataStore.newWriteOnlyTransaction();
            Assert.assertNotNull((String)"newWriteOnlyTransaction returned null", (Object)writeTx);
            writeTx.write(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
            DOMStoreThreePhaseCommitCohort cohort = writeTx.ready();
            cohort.canCommit().get(5L, TimeUnit.SECONDS);
            cohort.abort().get(5L, TimeUnit.SECONDS);
            testKit.testWriteTransaction(dataStore, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        }
    }

    @Test
    public void testTransactionChainWithSingleShard() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testTransactionChainWithSingleShard", "test-1");){
            DOMStoreTransactionChain txChain = dataStore.createTransactionChain();
            DOMStoreWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
            Assert.assertNotNull((String)"newWriteOnlyTransaction returned null", (Object)writeTx);
            ContainerNode testNode = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);
            writeTx.write(TestModel.TEST_PATH, (NormalizedNode)testNode);
            DOMStoreThreePhaseCommitCohort cohort1 = writeTx.ready();
            CountDownLatch continueCommit1 = new CountDownLatch(1);
            CountDownLatch commit1Done = new CountDownLatch(1);
            AtomicReference commit1Error = new AtomicReference();
            new Thread(() -> {
                try {
                    continueCommit1.await();
                    testKit.doCommit(cohort1);
                }
                catch (Exception e) {
                    commit1Error.set(e);
                }
                finally {
                    commit1Done.countDown();
                }
            }).start();
            DOMStoreReadTransaction readTx = txChain.newReadOnlyTransaction();
            Assert.assertEquals(Optional.of(testNode), (Object)readTx.read(TestModel.TEST_PATH).get(5L, TimeUnit.SECONDS));
            DOMStoreReadWriteTransaction rwTx = txChain.newReadWriteTransaction();
            MapNode outerNode = (MapNode)ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).withChild((NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)42)).build();
            rwTx.write(TestModel.OUTER_LIST_PATH, (NormalizedNode)outerNode);
            DOMStoreThreePhaseCommitCohort cohort2 = rwTx.ready();
            readTx = txChain.newReadWriteTransaction();
            Assert.assertEquals(Optional.of(outerNode), (Object)readTx.read(TestModel.OUTER_LIST_PATH).get(5L, TimeUnit.SECONDS));
            continueCommit1.countDown();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)commit1Done, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            if (commit1Error.get() != null) {
                throw (Exception)commit1Error.get();
            }
            testKit.doCommit(cohort2);
            txChain.close();
            readTx = dataStore.newReadOnlyTransaction();
            Assert.assertEquals(Optional.of(outerNode), (Object)readTx.read(TestModel.OUTER_LIST_PATH).get(5L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testTransactionChainWithMultipleShards() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testTransactionChainWithMultipleShards", "cars-1", "people-1");){
            DOMStoreTransactionChain txChain = dataStore.createTransactionChain();
            DOMStoreWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
            Assert.assertNotNull((String)"newWriteOnlyTransaction returned null", (Object)writeTx);
            writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
            writeTx.write(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.emptyContainer());
            writeTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
            writeTx.write(PeopleModel.PERSON_LIST_PATH, (NormalizedNode)PeopleModel.newPersonMapNode());
            DOMStoreThreePhaseCommitCohort cohort1 = writeTx.ready();
            DOMStoreReadWriteTransaction readWriteTx = txChain.newReadWriteTransaction();
            MapEntryNode car = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
            YangInstanceIdentifier carPath = CarsModel.newCarPath("optima");
            readWriteTx.write(carPath, (NormalizedNode)car);
            MapEntryNode person = PeopleModel.newPersonEntry("jack");
            YangInstanceIdentifier personPath = PeopleModel.newPersonPath("jack");
            readWriteTx.merge(personPath, (NormalizedNode)person);
            Assert.assertEquals(Optional.of(car), (Object)readWriteTx.read(carPath).get(5L, TimeUnit.SECONDS));
            Assert.assertEquals(Optional.of(person), (Object)readWriteTx.read(personPath).get(5L, TimeUnit.SECONDS));
            DOMStoreThreePhaseCommitCohort cohort2 = readWriteTx.ready();
            writeTx = txChain.newWriteOnlyTransaction();
            writeTx.delete(carPath);
            DOMStoreThreePhaseCommitCohort cohort3 = writeTx.ready();
            ListenableFuture canCommit1 = cohort1.canCommit();
            ListenableFuture canCommit2 = cohort2.canCommit();
            testKit.doCommit((ListenableFuture<Boolean>)canCommit1, cohort1);
            testKit.doCommit((ListenableFuture<Boolean>)canCommit2, cohort2);
            testKit.doCommit(cohort3);
            txChain.close();
            DOMStoreReadTransaction readTx = dataStore.newReadOnlyTransaction();
            Assert.assertEquals(Optional.empty(), (Object)readTx.read(carPath).get(5L, TimeUnit.SECONDS));
            Assert.assertEquals(Optional.of(person), (Object)readTx.read(personPath).get(5L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testCreateChainedTransactionsInQuickSuccession() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testCreateChainedTransactionsInQuickSuccession", "cars-1");){
            ConcurrentDOMDataBroker broker = new ConcurrentDOMDataBroker((Map)ImmutableMap.builder().put((Object)LogicalDatastoreType.CONFIGURATION, (Object)dataStore).build(), MoreExecutors.directExecutor());
            DOMTransactionChain txChain = broker.createTransactionChain();
            ArrayList<FluentFuture> futures = new ArrayList<FluentFuture>();
            DOMDataTreeWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
            writeTx.put(LogicalDatastoreType.CONFIGURATION, CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
            writeTx.put(LogicalDatastoreType.CONFIGURATION, CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
            futures.add(writeTx.commit());
            int numCars = 100;
            for (int i = 0; i < numCars; ++i) {
                DOMDataTreeReadWriteTransaction dOMDataTreeReadWriteTransaction = txChain.newReadWriteTransaction();
                dOMDataTreeReadWriteTransaction.merge(LogicalDatastoreType.CONFIGURATION, CarsModel.newCarPath("car" + i), (NormalizedNode)CarsModel.newCarEntry("car" + i, Uint64.valueOf((int)20000)));
                futures.add(dOMDataTreeReadWriteTransaction.commit());
            }
            for (ListenableFuture listenableFuture : futures) {
                listenableFuture.get(5L, TimeUnit.SECONDS);
            }
            Optional optional = (Optional)txChain.newReadOnlyTransaction().read(LogicalDatastoreType.CONFIGURATION, CarsModel.CAR_LIST_PATH).get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((String)"isPresent", (boolean)optional.isPresent());
            Assert.assertEquals((String)"# cars", (long)numCars, (long)((Collection)((NormalizedNode)optional.orElseThrow()).body()).size());
            txChain.close();
            broker.close();
        }
    }

    @Test
    public void testCreateChainedTransactionAfterEmptyTxReadied() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testCreateChainedTransactionAfterEmptyTxReadied", "test-1");){
            DOMStoreTransactionChain txChain = dataStore.createTransactionChain();
            DOMStoreReadWriteTransaction rwTx1 = txChain.newReadWriteTransaction();
            rwTx1.ready();
            DOMStoreReadWriteTransaction rwTx2 = txChain.newReadWriteTransaction();
            Optional optional = (Optional)rwTx2.read(TestModel.TEST_PATH).get(5L, TimeUnit.SECONDS);
            Assert.assertFalse((String)"isPresent", (boolean)optional.isPresent());
            txChain.close();
        }
    }

    @Test
    public void testCreateChainedTransactionWhenPreviousNotReady() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testCreateChainedTransactionWhenPreviousNotReady", "test-1");){
            DOMStoreTransactionChain txChain = dataStore.createTransactionChain();
            DOMStoreWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
            Assert.assertNotNull((String)"newWriteOnlyTransaction returned null", (Object)writeTx);
            writeTx.write(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
            testKit.assertExceptionOnTxChainCreates(txChain, IllegalStateException.class);
        }
    }

    @Test
    public void testCreateChainedTransactionAfterClose() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testCreateChainedTransactionAfterClose", "test-1");){
            DOMStoreTransactionChain txChain = dataStore.createTransactionChain();
            txChain.close();
            testKit.assertExceptionOnTxChainCreates(txChain, DOMTransactionChainClosedException.class);
        }
    }

    @Test
    public void testChainWithReadOnlyTxAfterPreviousReady() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testChainWithReadOnlyTxAfterPreviousReady", "test-1");){
            DOMStoreTransactionChain txChain = dataStore.createTransactionChain();
            DOMStoreWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
            writeTx.write(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
            DOMStoreThreePhaseCommitCohort cohort1 = writeTx.ready();
            FluentFuture readFuture1 = txChain.newReadOnlyTransaction().read(TestModel.TEST_PATH);
            FluentFuture readFuture2 = txChain.newReadOnlyTransaction().read(TestModel.TEST_PATH);
            DOMStoreWriteTransaction writeTx2 = txChain.newWriteOnlyTransaction();
            writeTx2.write(TestModel.OUTER_LIST_PATH, ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).withChild((NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)42)).build());
            Assert.assertTrue((String)"isPresent", (boolean)((Optional)readFuture1.get(5L, TimeUnit.SECONDS)).isPresent());
            Assert.assertTrue((String)"isPresent", (boolean)((Optional)readFuture2.get(5L, TimeUnit.SECONDS)).isPresent());
            DOMStoreThreePhaseCommitCohort cohort2 = writeTx2.ready();
            testKit.doCommit(cohort1);
            testKit.doCommit(cohort2);
            Assert.assertTrue((String)"isPresent", (boolean)((Optional)txChain.newReadOnlyTransaction().read(TestModel.OUTER_LIST_PATH).get(5L, TimeUnit.SECONDS)).isPresent());
        }
    }

    @Test
    public void testChainedTransactionFailureWithSingleShard() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testChainedTransactionFailureWithSingleShard", "cars-1");){
            ConcurrentDOMDataBroker broker = new ConcurrentDOMDataBroker((Map)ImmutableMap.builder().put((Object)LogicalDatastoreType.CONFIGURATION, (Object)dataStore).build(), MoreExecutors.directExecutor());
            FutureCallback listener = (FutureCallback)Mockito.mock(FutureCallback.class);
            DOMTransactionChain txChain = broker.createTransactionChain();
            txChain.addCallback(listener);
            DOMDataTreeReadWriteTransaction writeTx = txChain.newReadWriteTransaction();
            writeTx.put(LogicalDatastoreType.CONFIGURATION, PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.emptyContainer());
            ContainerNode invalidData = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CarsModel.BASE_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.JUNK_QNAME, (Object)"junk")).build();
            writeTx.merge(LogicalDatastoreType.CONFIGURATION, CarsModel.BASE_PATH, (NormalizedNode)invalidData);
            Assert.assertThrows(ExecutionException.class, () -> writeTx.commit().get(5L, TimeUnit.SECONDS));
            ((FutureCallback)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L))).onFailure((Throwable)ArgumentMatchers.any());
            txChain.close();
            broker.close();
        }
    }

    @Test
    public void testChainedTransactionFailureWithMultipleShards() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testChainedTransactionFailureWithMultipleShards", "cars-1", "people-1");){
            ConcurrentDOMDataBroker broker = new ConcurrentDOMDataBroker((Map)ImmutableMap.builder().put((Object)LogicalDatastoreType.CONFIGURATION, (Object)dataStore).build(), MoreExecutors.directExecutor());
            FutureCallback listener = (FutureCallback)Mockito.mock(FutureCallback.class);
            DOMTransactionChain txChain = broker.createTransactionChain();
            txChain.addCallback(listener);
            DOMDataTreeReadWriteTransaction writeTx = txChain.newReadWriteTransaction();
            writeTx.put(LogicalDatastoreType.CONFIGURATION, PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.emptyContainer());
            ContainerNode invalidData = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CarsModel.BASE_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.JUNK_QNAME, (Object)"junk")).build();
            writeTx.merge(LogicalDatastoreType.CONFIGURATION, CarsModel.BASE_PATH, (NormalizedNode)invalidData);
            Assert.assertThrows(ExecutionException.class, () -> AbstractDistributedDataStoreIntegrationTest.lambda$testChainedTransactionFailureWithMultipleShards$5((DOMDataTreeWriteTransaction)writeTx));
            ((FutureCallback)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L))).onFailure((Throwable)ArgumentMatchers.any());
            txChain.close();
            broker.close();
        }
    }

    @Test
    public void testDataTreeChangeListenerRegistration() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testDataTreeChangeListenerRegistration", "test-1");){
            testKit.testWriteTransaction(dataStore, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
            MockDataTreeChangeListener listener = new MockDataTreeChangeListener(1);
            Registration listenerReg = dataStore.registerTreeChangeListener(TestModel.TEST_PATH, (DOMDataTreeChangeListener)listener);
            Assert.assertNotNull((String)"registerTreeChangeListener returned null", (Object)listenerReg);
            IntegrationTestKit.verifyShardState(dataStore, "test-1", state -> Assert.assertEquals((String)"getTreeChangeListenerActors", (long)1L, (long)state.getTreeChangeListenerActors().size()));
            listener.waitForChangeEvents(TestModel.TEST_PATH);
            listener.reset(2);
            testKit.testWriteTransaction(dataStore, TestModel.OUTER_LIST_PATH, ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).withChild((NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)42)).build());
            YangInstanceIdentifier listPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.OUTER_LIST_PATH).nodeWithKey(TestModel.OUTER_LIST_QNAME, TestModel.ID_QNAME, (Object)1).build();
            testKit.testWriteTransaction(dataStore, listPath, (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)1));
            listener.waitForChangeEvents(TestModel.OUTER_LIST_PATH, listPath);
            listenerReg.close();
            IntegrationTestKit.verifyShardState(dataStore, "test-1", state -> Assert.assertEquals((String)"getTreeChangeListenerActors", (long)0L, (long)state.getTreeChangeListenerActors().size()));
            testKit.testWriteTransaction(dataStore, YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.OUTER_LIST_PATH).nodeWithKey(TestModel.OUTER_LIST_QNAME, TestModel.ID_QNAME, (Object)2).build(), (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)2));
            listener.expectNoMoreChanges("Received unexpected change after close");
        }
    }

    @Test
    public void testRestoreFromDatastoreSnapshot() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        String name = "transactionIntegrationTest";
        ContainerNode carsNode = CarsModel.newCarsNode(CarsModel.newCarsMapNode(CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000)), CarsModel.newCarEntry("sportage", Uint64.valueOf((int)30000))));
        DataTree dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, SchemaContextHelper.full());
        AbstractShardTest.writeToStore(dataTree, CarsModel.BASE_PATH, (NormalizedNode)carsNode);
        NormalizedNode root = AbstractShardTest.readStore(dataTree, YangInstanceIdentifier.of());
        Snapshot carsSnapshot = Snapshot.create((Snapshot.State)new ShardSnapshotState((ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot(root)), Collections.emptyList(), (long)2L, (long)1L, (long)2L, (long)1L, (long)1L, (String)"member-1", null);
        dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, SchemaContextHelper.full());
        ContainerNode peopleNode = PeopleModel.create();
        AbstractShardTest.writeToStore(dataTree, PeopleModel.BASE_PATH, (NormalizedNode)peopleNode);
        root = AbstractShardTest.readStore(dataTree, YangInstanceIdentifier.of());
        Snapshot peopleSnapshot = Snapshot.create((Snapshot.State)new ShardSnapshotState((ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot(root)), Collections.emptyList(), (long)2L, (long)1L, (long)2L, (long)1L, (long)1L, (String)"member-1", null);
        testKit.restoreFromSnapshot = new DatastoreSnapshot("transactionIntegrationTest", null, Arrays.asList(new DatastoreSnapshot.ShardSnapshot("cars", carsSnapshot), new DatastoreSnapshot.ShardSnapshot("people", peopleSnapshot)));
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "transactionIntegrationTest", "module-shards-member1.conf", true, "cars", "people");){
            DOMStoreReadTransaction readTx = dataStore.newReadOnlyTransaction();
            Assert.assertEquals(Optional.of(carsNode), (Object)readTx.read(CarsModel.BASE_PATH).get(5L, TimeUnit.SECONDS));
            Assert.assertEquals(Optional.of(peopleNode), (Object)readTx.read(PeopleModel.BASE_PATH).get(5L, TimeUnit.SECONDS));
        }
    }

    @Test
    @Ignore(value="ClientBackedDatastore does not have stable indexes/term, the snapshot index seems to fluctuate")
    public void testSnapshotOnRootOverwrite() throws Exception {
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder.snapshotOnRootOverwrite(true));
        try (ClientBackedDataStore dataStore = testKit.setupDataStore(this.testParameter, "testRootOverwrite", "module-shards-default-cars-member1.conf", true, "cars", "default");){
            ContainerNode rootNode = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)SchemaContext.NAME)).withChild((DataContainerChild)CarsModel.create()).build();
            testKit.testWriteTransaction(dataStore, YangInstanceIdentifier.of(), (NormalizedNode)rootNode);
            IntegrationTestKit.verifyShardState(dataStore, "cars", state -> Assert.assertEquals((long)1L, (long)state.getSnapshotIndex()));
            AbstractDistributedDataStoreIntegrationTest.verifySnapshot("member-1-shard-cars-testRootOverwrite", 1L, 1L);
            for (int i = 0; i < 10; ++i) {
                testKit.testWriteTransaction(dataStore, CarsModel.newCarPath("car " + i), (NormalizedNode)CarsModel.newCarEntry("car " + i, Uint64.ONE));
            }
            IntegrationTestKit.verifyShardState(dataStore, "cars", state -> Assert.assertEquals((long)10L, (long)state.getSnapshotIndex()));
            AbstractDistributedDataStoreIntegrationTest.verifySnapshot("member-1-shard-cars-testRootOverwrite", 1L, 1L);
            testKit.testWriteTransaction(dataStore, YangInstanceIdentifier.of(), (NormalizedNode)rootNode);
            IntegrationTestKit.verifyShardState(dataStore, "cars", state -> Assert.assertEquals((long)12L, (long)state.getSnapshotIndex()));
            AbstractDistributedDataStoreIntegrationTest.verifySnapshot("member-1-shard-cars-testRootOverwrite", 12L, 1L);
        }
    }

    private static void verifySnapshot(String persistenceId, long lastAppliedIndex, long lastAppliedTerm) {
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            List snap = InMemorySnapshotStore.getSnapshots((String)persistenceId, Snapshot.class);
            Assert.assertEquals((long)1L, (long)snap.size());
            Assert.assertEquals((long)lastAppliedIndex, (long)((Snapshot)snap.get(0)).getLastAppliedIndex());
            Assert.assertEquals((long)lastAppliedTerm, (long)((Snapshot)snap.get(0)).getLastAppliedTerm());
        });
    }

    private static /* synthetic */ void lambda$testChainedTransactionFailureWithMultipleShards$5(DOMDataTreeWriteTransaction writeTx) throws Throwable {
        writeTx.commit().get(5L, TimeUnit.SECONDS);
    }
}

