/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSystem;
import akka.testkit.javadsl.TestKit;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.ShardTransactionTest;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public abstract class AbstractTest {
    protected static final MemberName MEMBER_NAME = MemberName.forName((String)"member-1");
    protected static final MemberName MEMBER_2_NAME = MemberName.forName((String)"member-2");
    private static final FrontendType FRONTEND_TYPE = FrontendType.forName((String)ShardTransactionTest.class.getSimpleName());
    protected static final FrontendIdentifier FRONTEND_ID = FrontendIdentifier.create((MemberName)MEMBER_NAME, (FrontendType)FRONTEND_TYPE);
    private static final ClientIdentifier CLIENT_ID = ClientIdentifier.create((FrontendIdentifier)FRONTEND_ID, (long)0L);
    private static final LocalHistoryIdentifier HISTORY_ID = new LocalHistoryIdentifier(CLIENT_ID, 0L);
    private static final AtomicLong HISTORY_COUNTER = new AtomicLong();
    private static final AtomicLong TX_COUNTER = new AtomicLong();
    private final Collection<ActorSystem> actorSystems = new ArrayList<ActorSystem>();

    protected static void setUpStatic() {
        HISTORY_COUNTER.set(1L);
        TX_COUNTER.set(1L);
    }

    protected static TransactionIdentifier newTransactionId(long txId) {
        return new TransactionIdentifier(HISTORY_ID, txId);
    }

    protected static TransactionIdentifier nextTransactionId() {
        return AbstractTest.newTransactionId(TX_COUNTER.getAndIncrement());
    }

    protected static LocalHistoryIdentifier newHistoryId(long historyId) {
        return new LocalHistoryIdentifier(CLIENT_ID, historyId);
    }

    protected static LocalHistoryIdentifier nextHistoryId() {
        return AbstractTest.newHistoryId(HISTORY_COUNTER.incrementAndGet());
    }

    protected static <T> T waitOnAsyncTask(CompletionStage<T> completionStage, FiniteDuration timeout) throws Exception {
        return (T)Await.result((Awaitable)FutureConverters.toScala(completionStage), (Duration)timeout);
    }

    @After
    public void actorSystemCleanup() {
        for (ActorSystem system : this.actorSystems) {
            TestKit.shutdownActorSystem((ActorSystem)system, (boolean)true);
        }
    }

    protected ActorSystem newActorSystem(String name, String config) {
        ActorSystem system = ActorSystem.create((String)name, (Config)ConfigFactory.load().getConfig(config));
        this.actorSystems.add(system);
        return system;
    }
}

