/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Terminated;
import akka.dispatch.ExecutionContexts;
import akka.dispatch.Futures;
import akka.testkit.javadsl.TestKit;
import akka.util.Timeout;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DataTreeChangeListenerProxy;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.exceptions.NotInitializedException;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistration;
import org.opendaylight.controller.cluster.datastore.messages.FindLocalShard;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardFound;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardNotFound;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeNotificationListenerReply;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.raft.utils.DoNothingActor;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import scala.concurrent.ExecutionContextExecutor;

public class DataTreeChangeListenerProxyTest
extends AbstractActorTest {
    private final DOMDataTreeChangeListener mockListener = (DOMDataTreeChangeListener)Mockito.mock(DOMDataTreeChangeListener.class);

    @Test(timeout=10000L)
    public void testSuccessfulRegistration() {
        TestKit kit = new TestKit(DataTreeChangeListenerProxyTest.getSystem());
        ActorUtils actorUtils = new ActorUtils(DataTreeChangeListenerProxyTest.getSystem(), kit.getRef(), (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class));
        YangInstanceIdentifier path = YangInstanceIdentifier.of((QName)TestModel.TEST_QNAME);
        DataTreeChangeListenerProxy proxy = this.startProxyAsync(actorUtils, path, false);
        Duration timeout = Duration.ofSeconds(5L);
        FindLocalShard findLocalShard = (FindLocalShard)kit.expectMsgClass(timeout, FindLocalShard.class);
        Assert.assertEquals((Object)"shard-1", (Object)findLocalShard.getShardName());
        kit.reply((Object)new LocalShardFound(kit.getRef()));
        RegisterDataTreeChangeListener registerMsg = (RegisterDataTreeChangeListener)kit.expectMsgClass(timeout, RegisterDataTreeChangeListener.class);
        Assert.assertEquals((Object)path, (Object)registerMsg.getPath());
        Assert.assertFalse((boolean)registerMsg.isRegisterOnAllInstances());
        kit.reply((Object)new RegisterDataTreeNotificationListenerReply(kit.getRef()));
        for (int i = 0; i < 100 && proxy.getListenerRegistrationActor() == null; ++i) {
            Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertEquals((Object)DataTreeChangeListenerProxyTest.getSystem().actorSelection(kit.getRef().path()), (Object)proxy.getListenerRegistrationActor());
        kit.watch(proxy.getDataChangeListenerActor());
        proxy.close();
        kit.expectMsgClass(timeout, CloseDataTreeNotificationListenerRegistration.class);
        kit.expectMsgClass(timeout, Terminated.class);
        proxy.close();
        kit.expectNoMessage();
    }

    @Test(timeout=10000L)
    public void testSuccessfulRegistrationForClusteredListener() {
        TestKit kit = new TestKit(DataTreeChangeListenerProxyTest.getSystem());
        ActorUtils actorUtils = new ActorUtils(DataTreeChangeListenerProxyTest.getSystem(), kit.getRef(), (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class));
        YangInstanceIdentifier path = YangInstanceIdentifier.of((QName)TestModel.TEST_QNAME);
        DataTreeChangeListenerProxy proxy = this.startProxyAsync(actorUtils, path, true);
        Duration timeout = Duration.ofSeconds(5L);
        FindLocalShard findLocalShard = (FindLocalShard)kit.expectMsgClass(timeout, FindLocalShard.class);
        Assert.assertEquals((Object)"shard-1", (Object)findLocalShard.getShardName());
        kit.reply((Object)new LocalShardFound(kit.getRef()));
        RegisterDataTreeChangeListener registerMsg = (RegisterDataTreeChangeListener)kit.expectMsgClass(timeout, RegisterDataTreeChangeListener.class);
        Assert.assertEquals((Object)path, (Object)registerMsg.getPath());
        Assert.assertTrue((boolean)registerMsg.isRegisterOnAllInstances());
        proxy.close();
    }

    @Test(timeout=10000L)
    public void testLocalShardNotFound() {
        TestKit kit = new TestKit(DataTreeChangeListenerProxyTest.getSystem());
        ActorUtils actorUtils = new ActorUtils(DataTreeChangeListenerProxyTest.getSystem(), kit.getRef(), (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class));
        YangInstanceIdentifier path = YangInstanceIdentifier.of((QName)TestModel.TEST_QNAME);
        DataTreeChangeListenerProxy proxy = this.startProxyAsync(actorUtils, path, true);
        Duration timeout = Duration.ofSeconds(5L);
        FindLocalShard findLocalShard = (FindLocalShard)kit.expectMsgClass(timeout, FindLocalShard.class);
        Assert.assertEquals((Object)"shard-1", (Object)findLocalShard.getShardName());
        kit.reply((Object)new LocalShardNotFound("shard-1"));
        kit.expectNoMessage(Duration.ofSeconds(1L));
        proxy.close();
    }

    @Test(timeout=10000L)
    public void testLocalShardNotInitialized() {
        TestKit kit = new TestKit(DataTreeChangeListenerProxyTest.getSystem());
        ActorUtils actorUtils = new ActorUtils(DataTreeChangeListenerProxyTest.getSystem(), kit.getRef(), (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class));
        YangInstanceIdentifier path = YangInstanceIdentifier.of((QName)TestModel.TEST_QNAME);
        DataTreeChangeListenerProxy proxy = this.startProxyAsync(actorUtils, path, false);
        Duration timeout = Duration.ofSeconds(5L);
        FindLocalShard findLocalShard = (FindLocalShard)kit.expectMsgClass(timeout, FindLocalShard.class);
        Assert.assertEquals((Object)"shard-1", (Object)findLocalShard.getShardName());
        kit.reply((Object)new NotInitializedException("not initialized"));
        kit.within(Duration.ofSeconds(1L), () -> {
            kit.expectNoMessage();
            return null;
        });
        proxy.close();
    }

    @Test
    public void testFailedRegistration() {
        TestKit kit = new TestKit(DataTreeChangeListenerProxyTest.getSystem());
        ActorSystem mockActorSystem = (ActorSystem)Mockito.mock(ActorSystem.class);
        ActorRef mockActor = DataTreeChangeListenerProxyTest.getSystem().actorOf(Props.create(DoNothingActor.class, (Object[])new Object[0]), "testFailedRegistration");
        ((ActorSystem)Mockito.doReturn((Object)mockActor).when((Object)mockActorSystem)).actorOf((Props)ArgumentMatchers.any(Props.class));
        ExecutionContextExecutor executor = ExecutionContexts.fromExecutor((Executor)MoreExecutors.directExecutor());
        ActorUtils actorUtils = (ActorUtils)Mockito.mock(ActorUtils.class);
        YangInstanceIdentifier path = YangInstanceIdentifier.of((QName)TestModel.TEST_QNAME);
        ((ActorUtils)Mockito.doReturn((Object)executor).when((Object)actorUtils)).getClientDispatcher();
        ((ActorUtils)Mockito.doReturn((Object)DatastoreContext.newBuilder().build()).when((Object)actorUtils)).getDatastoreContext();
        ((ActorUtils)Mockito.doReturn((Object)mockActorSystem).when((Object)actorUtils)).getActorSystem();
        ((ActorUtils)Mockito.doReturn((Object)kit.duration("5 seconds")).when((Object)actorUtils)).getOperationDuration();
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)kit.getRef())).when((Object)actorUtils)).findLocalShardAsync("shard-1");
        ((ActorUtils)Mockito.doReturn((Object)Futures.failed((Throwable)new RuntimeException("mock"))).when((Object)actorUtils)).executeOperationAsync((ActorRef)ArgumentMatchers.any(ActorRef.class), ArgumentMatchers.any(Object.class), (Timeout)ArgumentMatchers.any(Timeout.class));
        DataTreeChangeListenerProxy proxy = DataTreeChangeListenerProxy.of((ActorUtils)actorUtils, (DOMDataTreeChangeListener)this.mockListener, (YangInstanceIdentifier)path, (boolean)true, (String)"shard-1");
        Assert.assertNull((Object)proxy.getListenerRegistrationActor());
        proxy.close();
    }

    @Test
    public void testCloseBeforeRegistration() {
        TestKit kit = new TestKit(DataTreeChangeListenerProxyTest.getSystem());
        ActorUtils actorUtils = (ActorUtils)Mockito.mock(ActorUtils.class);
        ((ActorUtils)Mockito.doReturn((Object)DatastoreContext.newBuilder().build()).when((Object)actorUtils)).getDatastoreContext();
        ((ActorUtils)Mockito.doReturn((Object)DataTreeChangeListenerProxyTest.getSystem().dispatchers().defaultGlobalDispatcher()).when((Object)actorUtils)).getClientDispatcher();
        ((ActorUtils)Mockito.doReturn((Object)DataTreeChangeListenerProxyTest.getSystem()).when((Object)actorUtils)).getActorSystem();
        ((ActorUtils)Mockito.doReturn((Object)"akka.actor.default-dispatcher").when((Object)actorUtils)).getNotificationDispatcherPath();
        ((ActorUtils)Mockito.doReturn((Object)DataTreeChangeListenerProxyTest.getSystem().actorSelection(kit.getRef().path())).when((Object)actorUtils)).actorSelection(kit.getRef().path());
        ((ActorUtils)Mockito.doReturn((Object)kit.duration("5 seconds")).when((Object)actorUtils)).getOperationDuration();
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful((Object)kit.getRef())).when((Object)actorUtils)).findLocalShardAsync("shard-1");
        Map.Entry<DataTreeChangeListenerProxy, Runnable> proxy = this.createProxy(actorUtils, YangInstanceIdentifier.of((QName)TestModel.TEST_QNAME), true);
        DataTreeChangeListenerProxy instance = proxy.getKey();
        ((ActorUtils)Mockito.doAnswer(invocation -> {
            instance.close();
            return Futures.successful((Object)new RegisterDataTreeNotificationListenerReply(kit.getRef()));
        }).when((Object)actorUtils)).executeOperationAsync((ActorRef)ArgumentMatchers.any(ActorRef.class), ArgumentMatchers.any(Object.class), (Timeout)ArgumentMatchers.any(Timeout.class));
        proxy.getValue().run();
        kit.expectMsgClass(Duration.ofSeconds(5L), CloseDataTreeNotificationListenerRegistration.class);
        Assert.assertNull((Object)instance.getListenerRegistrationActor());
    }

    @NonNullByDefault
    private DataTreeChangeListenerProxy startProxyAsync(ActorUtils actorUtils, YangInstanceIdentifier path, boolean clustered) {
        return this.startProxyAsync(actorUtils, path, clustered, Runnable::run);
    }

    @NonNullByDefault
    private DataTreeChangeListenerProxy startProxyAsync(ActorUtils actorUtils, YangInstanceIdentifier path, boolean clustered, Consumer<Runnable> execute) {
        Map.Entry<DataTreeChangeListenerProxy, Runnable> proxy = this.createProxy(actorUtils, path, clustered);
        Thread thread = new Thread(proxy.getValue());
        thread.setDaemon(true);
        thread.start();
        return proxy.getKey();
    }

    @NonNullByDefault
    private Map.Entry<DataTreeChangeListenerProxy, Runnable> createProxy(ActorUtils actorUtils, YangInstanceIdentifier path, boolean clustered) {
        Executor executor = (Executor)Mockito.mock(Executor.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Runnable.class);
        ((Executor)Mockito.doNothing().when((Object)executor)).execute((Runnable)captor.capture());
        DataTreeChangeListenerProxy proxy = DataTreeChangeListenerProxy.ofTesting((ActorUtils)actorUtils, (DOMDataTreeChangeListener)this.mockListener, (YangInstanceIdentifier)path, (boolean)clustered, (String)"shard-1", (Executor)executor);
        return Map.entry(proxy, (Runnable)captor.getValue());
    }
}

