/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospector;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospectorTest;
import org.opendaylight.controller.cluster.datastore.DatastoreContextPropertiesUpdater;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;

public class DatastoreContextContextPropertiesUpdaterTest {
    @Test
    public void updateOnConstructionTest() throws Exception {
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("shardTransactionIdleTimeoutInMinutes", 10);
        DatastoreContextIntrospector introspector = DatastoreContextIntrospectorTest.INTROSPECTOR_FACTORY.newInstance(LogicalDatastoreType.CONFIGURATION);
        DatastoreContextPropertiesUpdater updater = new DatastoreContextPropertiesUpdater(introspector, properties);
        Assert.assertNotNull((Object)updater);
        Map props = (Map)DatastoreContextContextPropertiesUpdaterTest.resolveField("currentProperties", introspector);
        Assert.assertEquals(props.get("shardTransactionIdleTimeoutInMinutes"), (Object)10);
    }

    @Test
    public void onUpdateTest() throws Exception {
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("shardTransactionIdleTimeoutInMinutes", 10);
        DatastoreContextIntrospector introspector = DatastoreContextIntrospectorTest.INTROSPECTOR_FACTORY.newInstance(LogicalDatastoreType.CONFIGURATION);
        Assert.assertNotNull((Object)introspector);
        DatastoreContextPropertiesUpdater updater = new DatastoreContextPropertiesUpdater(introspector, properties);
        Assert.assertNotNull((Object)updater);
        Map props = (Map)DatastoreContextContextPropertiesUpdaterTest.resolveField("currentProperties", introspector);
        Assert.assertTrue((!props.isEmpty() ? 1 : 0) != 0);
        properties.put("shardTransactionIdleTimeoutInMinutes", 20);
        updater.update(properties);
        props = (Map)DatastoreContextContextPropertiesUpdaterTest.resolveField("currentProperties", introspector);
        Assert.assertEquals(props.get("shardTransactionIdleTimeoutInMinutes"), (Object)20);
    }

    @Test
    public void listenerTest() {
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("shardTransactionIdleTimeoutInMinutes", 10);
        DatastoreContextIntrospector introspector = DatastoreContextIntrospectorTest.INTROSPECTOR_FACTORY.newInstance(LogicalDatastoreType.CONFIGURATION);
        DatastoreContextPropertiesUpdater updater = new DatastoreContextPropertiesUpdater(introspector, properties);
        DummyListenerImpl dummyListener = new DummyListenerImpl();
        updater.setListener((DatastoreContextPropertiesUpdater.Listener)dummyListener);
        Assert.assertTrue((dummyListener.getContextFactory() == null ? 1 : 0) != 0);
        updater.setListener((DatastoreContextPropertiesUpdater.Listener)dummyListener);
        properties.put("shardTransactionIdleTimeoutInMinutes", 20);
        updater.update(properties);
        DatastoreContextFactory contextFactory = dummyListener.getContextFactory();
        Assert.assertNotNull((Object)contextFactory);
        updater.close();
    }

    private static Object resolveField(String name, Object obj) throws Exception {
        Field currProps = obj.getClass().getDeclaredField(name);
        currProps.setAccessible(true);
        return currProps.get(obj);
    }

    private static final class DummyListenerImpl
    implements DatastoreContextPropertiesUpdater.Listener {
        private DatastoreContextFactory contextFactory;

        private DummyListenerImpl() {
        }

        public void onDatastoreContextUpdated(DatastoreContextFactory contextFactory) {
            this.contextFactory = contextFactory;
        }

        public DatastoreContextFactory getContextFactory() {
            return this.contextFactory;
        }
    }
}

