/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.databroker.ClientBackedDataStore;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.ClusterWrapperImpl;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardStats;
import org.opendaylight.controller.cluster.datastore.ShardTestKit;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ConfigurationImpl;
import org.opendaylight.controller.cluster.datastore.messages.OnDemandShardState;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.raft.client.messages.GetOnDemandRaftState;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class IntegrationTestKit
extends ShardTestKit {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestKit.class);
    protected DatastoreContext.Builder datastoreContextBuilder;
    protected DatastoreSnapshot restoreFromSnapshot;
    private final int commitTimeout;

    public IntegrationTestKit(ActorSystem actorSystem, DatastoreContext.Builder datastoreContextBuilder) {
        this(actorSystem, datastoreContextBuilder, 7);
    }

    public IntegrationTestKit(ActorSystem actorSystem, DatastoreContext.Builder datastoreContextBuilder, int commitTimeout) {
        super(actorSystem);
        this.datastoreContextBuilder = datastoreContextBuilder;
        this.commitTimeout = commitTimeout;
    }

    public DatastoreContext.Builder getDatastoreContextBuilder() {
        return this.datastoreContextBuilder;
    }

    public ClientBackedDataStore setupDataStore(Class<? extends ClientBackedDataStore> implementation, String typeName, String ... shardNames) throws Exception {
        return this.setupDataStore(implementation, typeName, "module-shards.conf", true, SchemaContextHelper.full(), shardNames);
    }

    public ClientBackedDataStore setupDataStore(Class<? extends ClientBackedDataStore> implementation, String typeName, boolean waitUntilLeader, String ... shardNames) throws Exception {
        return this.setupDataStore(implementation, typeName, "module-shards.conf", waitUntilLeader, SchemaContextHelper.full(), shardNames);
    }

    public ClientBackedDataStore setupDataStore(Class<? extends ClientBackedDataStore> implementation, String typeName, String moduleShardsConfig, boolean waitUntilLeader, String ... shardNames) throws Exception {
        return this.setupDataStore(implementation, typeName, moduleShardsConfig, waitUntilLeader, SchemaContextHelper.full(), shardNames);
    }

    public ClientBackedDataStore setupDataStore(Class<? extends ClientBackedDataStore> implementation, String typeName, String moduleShardsConfig, boolean waitUntilLeader, EffectiveModelContext schemaContext, String ... shardNames) throws Exception {
        return this.setupDataStore(implementation, typeName, moduleShardsConfig, "modules.conf", waitUntilLeader, schemaContext, shardNames);
    }

    private ClientBackedDataStore setupDataStore(Class<? extends ClientBackedDataStore> implementation, String typeName, String moduleShardsConfig, String modulesConfig, boolean waitUntilLeader, EffectiveModelContext schemaContext, String ... shardNames) throws Exception {
        ClusterWrapperImpl cluster = new ClusterWrapperImpl(this.getSystem());
        ConfigurationImpl config = new ConfigurationImpl(moduleShardsConfig, modulesConfig);
        this.setDataStoreName(typeName);
        DatastoreContext datastoreContext = this.datastoreContextBuilder.build();
        DatastoreContextFactory mockContextFactory = (DatastoreContextFactory)Mockito.mock(DatastoreContextFactory.class);
        ((DatastoreContextFactory)Mockito.doReturn((Object)datastoreContext).when((Object)mockContextFactory)).getBaseDatastoreContext();
        ((DatastoreContextFactory)Mockito.doReturn((Object)datastoreContext).when((Object)mockContextFactory)).getShardDatastoreContext(ArgumentMatchers.anyString());
        Constructor<? extends ClientBackedDataStore> constructor = implementation.getDeclaredConstructor(ActorSystem.class, ClusterWrapper.class, Configuration.class, DatastoreContextFactory.class, DatastoreSnapshot.class);
        ClientBackedDataStore dataStore = constructor.newInstance(this.getSystem(), cluster, config, mockContextFactory, this.restoreFromSnapshot);
        dataStore.onModelContextUpdated(schemaContext);
        if (waitUntilLeader) {
            this.waitUntilLeader(dataStore.getActorUtils(), shardNames);
        }
        this.datastoreContextBuilder = DatastoreContext.newBuilderFrom((DatastoreContext)datastoreContext);
        return dataStore;
    }

    private void setDataStoreName(String typeName) {
        if ("config".equals(typeName)) {
            this.datastoreContextBuilder.logicalStoreType(LogicalDatastoreType.CONFIGURATION);
        } else if ("operational".equals(typeName)) {
            this.datastoreContextBuilder.logicalStoreType(LogicalDatastoreType.OPERATIONAL);
        } else {
            this.datastoreContextBuilder.dataStoreName(typeName);
        }
    }

    public void waitUntilLeader(ActorUtils actorUtils, String ... shardNames) {
        for (String shardName : shardNames) {
            ActorRef shard = IntegrationTestKit.findLocalShard(actorUtils, shardName);
            Assert.assertNotNull((String)("Shard was not created for " + shardName), (Object)shard);
            IntegrationTestKit.waitUntilLeader(shard);
        }
    }

    public void waitUntilNoLeader(ActorUtils actorUtils, String ... shardNames) {
        for (String shardName : shardNames) {
            ActorRef shard = IntegrationTestKit.findLocalShard(actorUtils, shardName);
            Assert.assertNotNull((String)("No local shard found for " + shardName), (Object)shard);
            this.waitUntilNoLeader(shard);
        }
    }

    public void waitForMembersUp(String ... otherMembers) {
        HashSet otherMembersSet = Sets.newHashSet((Object[])otherMembers);
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= 10L) {
            ClusterEvent.CurrentClusterState state = Cluster.get((ActorSystem)this.getSystem()).state();
            for (Member m : state.getMembers()) {
                if (m.status() != MemberStatus.up() || !otherMembersSet.remove(m.getRoles().iterator().next()) || !otherMembersSet.isEmpty()) continue;
                return;
            }
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.fail((String)("Member(s) " + otherMembersSet + " are not Up"));
    }

    public static ActorRef findLocalShard(ActorUtils actorUtils, String shardName) {
        for (int i = 0; i < 100; ++i) {
            Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            Optional shardReply = actorUtils.findLocalShard(shardName);
            if (!shardReply.isPresent()) continue;
            return (ActorRef)shardReply.orElseThrow();
        }
        return null;
    }

    public static void waitUntilShardIsDown(ActorUtils actorUtils, String shardName) {
        for (int i = 0; i < 100; ++i) {
            LOG.debug("Waiting for shard down {}", (Object)shardName);
            Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            Optional shardReply = actorUtils.findLocalShard(shardName);
            if (shardReply.isPresent()) continue;
            return;
        }
        throw new IllegalStateException("Shard[" + shardName + " did not shutdown in time");
    }

    public static void verifyShardStats(ClientBackedDataStore datastore, String shardName, ShardStatsVerifier verifier) throws Exception {
        ActorUtils actorUtils = datastore.getActorUtils();
        Future future = actorUtils.findLocalShardAsync(shardName);
        ActorRef shardActor = (ActorRef)Await.result((Awaitable)future, (Duration)FiniteDuration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        AssertionError lastError = null;
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= 5L) {
            ShardStats shardStats = (ShardStats)actorUtils.executeOperation(shardActor, Shard.GET_SHARD_MBEAN_MESSAGE);
            try {
                verifier.verify(shardStats);
                return;
            }
            catch (AssertionError e) {
                lastError = e;
                Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        throw lastError;
    }

    public static void verifyShardState(ClientBackedDataStore datastore, String shardName, Consumer<OnDemandShardState> verifier) throws Exception {
        ActorUtils actorUtils = datastore.getActorUtils();
        Future future = actorUtils.findLocalShardAsync(shardName);
        ActorRef shardActor = (ActorRef)Await.result((Awaitable)future, (Duration)FiniteDuration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        AssertionError lastError = null;
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= 5L) {
            OnDemandShardState shardState = (OnDemandShardState)actorUtils.executeOperation(shardActor, (Object)GetOnDemandRaftState.INSTANCE);
            try {
                verifier.accept(shardState);
                return;
            }
            catch (AssertionError e) {
                lastError = e;
                Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        throw lastError;
    }

    void testWriteTransaction(ClientBackedDataStore dataStore, YangInstanceIdentifier nodePath, NormalizedNode nodeToWrite) throws Exception {
        DOMStoreWriteTransaction writeTx = dataStore.newWriteOnlyTransaction();
        Assert.assertNotNull((String)"newWriteOnlyTransaction returned null", (Object)writeTx);
        writeTx.write(nodePath, nodeToWrite);
        DOMStoreThreePhaseCommitCohort cohort = writeTx.ready();
        this.doCommit(cohort);
        DOMStoreReadTransaction readTx = dataStore.newReadOnlyTransaction();
        Assert.assertEquals(Optional.of(nodeToWrite), (Object)readTx.read(nodePath).get(5L, TimeUnit.SECONDS));
    }

    public void doCommit(DOMStoreThreePhaseCommitCohort cohort) throws Exception {
        Boolean canCommit = (Boolean)cohort.canCommit().get((long)this.commitTimeout, TimeUnit.SECONDS);
        Assert.assertEquals((String)"canCommit", (Object)Boolean.TRUE, (Object)canCommit);
        cohort.preCommit().get(5L, TimeUnit.SECONDS);
        cohort.commit().get(5L, TimeUnit.SECONDS);
    }

    void doCommit(ListenableFuture<Boolean> canCommitFuture, DOMStoreThreePhaseCommitCohort cohort) throws Exception {
        Boolean canCommit = (Boolean)canCommitFuture.get((long)this.commitTimeout, TimeUnit.SECONDS);
        Assert.assertEquals((String)"canCommit", (Object)Boolean.TRUE, (Object)canCommit);
        cohort.preCommit().get(5L, TimeUnit.SECONDS);
        cohort.commit().get(5L, TimeUnit.SECONDS);
    }

    void assertExceptionOnTxChainCreates(DOMStoreTransactionChain txChain, Class<? extends Exception> expType) {
        Assert.assertThrows(expType, () -> txChain.newWriteOnlyTransaction());
        Assert.assertThrows(expType, () -> txChain.newReadWriteTransaction());
        Assert.assertThrows(expType, () -> txChain.newReadOnlyTransaction());
    }

    public static interface ShardStatsVerifier {
        public void verify(ShardStats var1);
    }
}

