/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.AddressFromURIString;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Uninterruptibles;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.databroker.ClientBackedDataStore;
import org.opendaylight.controller.cluster.datastore.ClusterWrapperImpl;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.IntegrationTestKit;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.raft.client.messages.GetOnDemandRaftState;
import org.opendaylight.controller.cluster.raft.client.messages.OnDemandRaftState;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class MemberNode {
    private static final String MEMBER_1_ADDRESS = "akka://cluster-test@127.0.0.1:2558";
    private IntegrationTestKit kit;
    private ClientBackedDataStore configDataStore;
    private ClientBackedDataStore operDataStore;
    private DatastoreContext.Builder datastoreContextBuilder;
    private boolean cleanedUp;

    public static Builder builder(List<MemberNode> members) {
        return new Builder(members);
    }

    public IntegrationTestKit kit() {
        return this.kit;
    }

    public ClientBackedDataStore configDataStore() {
        return this.configDataStore;
    }

    public ClientBackedDataStore operDataStore() {
        return this.operDataStore;
    }

    public DatastoreContext.Builder datastoreContextBuilder() {
        return this.datastoreContextBuilder;
    }

    public void waitForMembersUp(String ... otherMembers) {
        this.kit.waitForMembersUp(otherMembers);
    }

    public void waitForMemberDown(String member) {
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= 10L) {
            ClusterEvent.CurrentClusterState state = Cluster.get((ActorSystem)this.kit.getSystem()).state();
            for (Member m : state.getUnreachable()) {
                if (!member.equals(m.getRoles().iterator().next())) continue;
                return;
            }
            for (Member m : state.getMembers()) {
                if (m.status() == MemberStatus.up() || !member.equals(m.getRoles().iterator().next())) continue;
                return;
            }
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.fail((String)("Member " + member + " is now down"));
    }

    public void cleanup() {
        if (!this.cleanedUp) {
            this.cleanedUp = true;
            if (this.configDataStore != null) {
                this.configDataStore.close();
            }
            if (this.operDataStore != null) {
                this.operDataStore.close();
            }
            try {
                IntegrationTestKit.shutdownActorSystem((ActorSystem)this.kit.getSystem(), (boolean)true);
            }
            catch (RuntimeException e) {
                LoggerFactory.getLogger(MemberNode.class).warn("Failed to shutdown actor system", (Throwable)e);
            }
        }
    }

    public static void verifyRaftState(ClientBackedDataStore datastore, String shardName, RaftStateVerifier verifier) throws Exception {
        ActorUtils actorUtils = datastore.getActorUtils();
        Future future = actorUtils.findLocalShardAsync(shardName);
        ActorRef shardActor = (ActorRef)Await.result((Awaitable)future, (Duration)FiniteDuration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        AssertionError lastError = null;
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= 5L) {
            OnDemandRaftState raftState = (OnDemandRaftState)actorUtils.executeOperation(shardActor, (Object)GetOnDemandRaftState.INSTANCE);
            try {
                verifier.verify(raftState);
                return;
            }
            catch (AssertionError e) {
                lastError = e;
                Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        throw lastError;
    }

    public static void verifyRaftPeersPresent(ClientBackedDataStore datastore, String shardName, String ... peerMemberNames) throws Exception {
        HashSet<String> peerIds = new HashSet<String>();
        for (String p : peerMemberNames) {
            peerIds.add(ShardIdentifier.create((String)shardName, (MemberName)MemberName.forName((String)p), (String)datastore.getActorUtils().getDataStoreName()).toString());
        }
        MemberNode.verifyRaftState(datastore, shardName, raftState -> Assert.assertEquals((String)("Peers for shard " + shardName), (Object)peerIds, raftState.getPeerAddresses().keySet()));
    }

    public static void verifyNoShardPresent(ClientBackedDataStore datastore, String shardName) {
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= 5L) {
            Optional shardReply = datastore.getActorUtils().findLocalShard(shardName);
            if (!shardReply.isPresent()) {
                return;
            }
            Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.fail((String)("Shard " + shardName + " is present"));
    }

    public static class Builder {
        private final List<MemberNode> members;
        private String moduleShardsConfig;
        private String akkaConfig;
        private boolean useAkkaArtery = true;
        private String[] waitForshardLeader = new String[0];
        private String testName;
        private EffectiveModelContext schemaContext;
        private boolean createOperDatastore = true;
        private DatastoreContext.Builder datastoreContextBuilder = DatastoreContext.newBuilder().shardHeartbeatIntervalInMillis(300).shardElectionTimeoutFactor(30L);

        Builder(List<MemberNode> members) {
            this.members = members;
        }

        public Builder moduleShardsConfig(String newModuleShardsConfig) {
            this.moduleShardsConfig = newModuleShardsConfig;
            return this;
        }

        public Builder akkaConfig(String newAkkaConfig) {
            this.akkaConfig = newAkkaConfig;
            return this;
        }

        public Builder useAkkaArtery(boolean newUseAkkaArtery) {
            this.useAkkaArtery = newUseAkkaArtery;
            return this;
        }

        public Builder testName(String newTestName) {
            this.testName = newTestName;
            return this;
        }

        public Builder waitForShardLeader(String ... shardNames) {
            this.waitForshardLeader = shardNames;
            return this;
        }

        public Builder createOperDatastore(boolean value) {
            this.createOperDatastore = value;
            return this;
        }

        public Builder schemaContext(EffectiveModelContext newSchemaContext) {
            this.schemaContext = newSchemaContext;
            return this;
        }

        public Builder datastoreContextBuilder(DatastoreContext.Builder builder) {
            this.datastoreContextBuilder = builder;
            return this;
        }

        public MemberNode build() throws Exception {
            Objects.requireNonNull(this.moduleShardsConfig, "moduleShardsConfig must be specified");
            Objects.requireNonNull(this.akkaConfig, "akkaConfig must be specified");
            Objects.requireNonNull(this.testName, "testName must be specified");
            if (this.schemaContext == null) {
                this.schemaContext = SchemaContextHelper.full();
            }
            MemberNode node = new MemberNode();
            node.datastoreContextBuilder = this.datastoreContextBuilder;
            Config baseConfig = ConfigFactory.load();
            Config config = this.useAkkaArtery ? baseConfig.getConfig(this.akkaConfig) : baseConfig.getConfig(this.akkaConfig + "-without-artery").withFallback((ConfigMergeable)baseConfig.getConfig(this.akkaConfig));
            ActorSystem system = ActorSystem.create((String)"cluster-test", (Config)config);
            String member1Address = this.useAkkaArtery ? MemberNode.MEMBER_1_ADDRESS : MemberNode.MEMBER_1_ADDRESS.replace("akka", "akka.tcp");
            Cluster.get((ActorSystem)system).join(AddressFromURIString.parse((String)member1Address));
            node.kit = new IntegrationTestKit(system, this.datastoreContextBuilder);
            String memberName = new ClusterWrapperImpl(system).getCurrentMemberName().getName();
            node.kit.getDatastoreContextBuilder().shardManagerPersistenceId("shard-manager-config-" + memberName);
            node.configDataStore = node.kit.setupDataStore(ClientBackedDataStore.class, "config_" + this.testName, this.moduleShardsConfig, true, this.schemaContext, this.waitForshardLeader);
            if (this.createOperDatastore) {
                node.kit.getDatastoreContextBuilder().shardManagerPersistenceId("shard-manager-oper-" + memberName);
                node.operDataStore = node.kit.setupDataStore(ClientBackedDataStore.class, "oper_" + this.testName, this.moduleShardsConfig, true, this.schemaContext, this.waitForshardLeader);
            }
            this.members.add(node);
            return node;
        }
    }

    public static interface RaftStateVerifier {
        public void verify(OnDemandRaftState var1);
    }
}

