/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.dispatch.Dispatchers;
import akka.testkit.TestActorRef;
import akka.testkit.javadsl.TestKit;
import com.google.common.collect.ImmutableSortedSet;
import java.time.Duration;
import java.util.SortedSet;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractShardTest;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardTestKit;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.CanCommitTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CanCommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.ReadyTransactionReply;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="9.0.0", forRemoval=true)
public class ShardCommitCoordinationTest
extends AbstractShardTest {
    private static final Logger LOG = LoggerFactory.getLogger(ShardCommitCoordinationTest.class);

    @Test
    public void testTwoTransactionsWithSameTwoParticipatingShards() {
        String testName = "testTwoTransactionsWithSameTwoParticipatingShards";
        LOG.info("{} starting", (Object)"testTwoTransactionsWithSameTwoParticipatingShards");
        TestKit kit1 = new TestKit(ShardCommitCoordinationTest.getSystem());
        TestKit kit2 = new TestKit(ShardCommitCoordinationTest.getSystem());
        ShardIdentifier shardAId = ShardIdentifier.create((String)"shardA", (MemberName)MemberName.forName((String)"testTwoTransactionsWithSameTwoParticipatingShards"), (String)"config");
        ShardIdentifier shardBId = ShardIdentifier.create((String)"shardB", (MemberName)MemberName.forName((String)"testTwoTransactionsWithSameTwoParticipatingShards"), (String)"config");
        TestActorRef shardA = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().id(shardAId)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ShardTestKit.waitUntilLeader((ActorRef)shardA);
        TestActorRef shardB = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().id(shardBId)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ShardTestKit.waitUntilLeader((ActorRef)shardB);
        TransactionIdentifier txId1 = ShardCommitCoordinationTest.nextTransactionId();
        TransactionIdentifier txId2 = ShardCommitCoordinationTest.nextTransactionId();
        ImmutableSortedSet participatingShardNames = ImmutableSortedSet.of((Comparable)((Object)shardAId.getShardName()), (Comparable)((Object)shardBId.getShardName()));
        shardA.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), (SortedSet<String>)participatingShardNames), kit1.getRef());
        kit1.expectMsgClass(ReadyTransactionReply.class);
        shardA.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId2, TestModel.OUTER_LIST_PATH, (NormalizedNode)TestModel.outerNode(1), (SortedSet<String>)participatingShardNames), kit2.getRef());
        kit2.expectMsgClass(ReadyTransactionReply.class);
        shardB.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId2, TestModel.OUTER_LIST_PATH, (NormalizedNode)TestModel.outerNode(1), (SortedSet<String>)participatingShardNames), kit2.getRef());
        kit2.expectMsgClass(ReadyTransactionReply.class);
        shardB.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), (SortedSet<String>)participatingShardNames), kit1.getRef());
        kit1.expectMsgClass(ReadyTransactionReply.class);
        shardA.tell(new CanCommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectNoMessage(Duration.ofMillis(100L));
        shardA.tell(new CanCommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CanCommitTransactionReply.class);
        shardB.tell(new CanCommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CanCommitTransactionReply.class);
        shardB.tell(new CanCommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectNoMessage(Duration.ofMillis(100L));
        shardA.tell(new CommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CommitTransactionReply.class);
        shardB.tell(new CommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CommitTransactionReply.class);
        kit2.expectMsgClass(CanCommitTransactionReply.class);
        kit2.expectMsgClass(CanCommitTransactionReply.class);
        shardA.tell(new CommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CommitTransactionReply.class);
        shardB.tell(new CommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CommitTransactionReply.class);
        ShardCommitCoordinationTest.verifyOuterListEntry((TestActorRef<Shard>)shardA, 1);
        ShardCommitCoordinationTest.verifyOuterListEntry((TestActorRef<Shard>)shardB, 1);
        LOG.info("{} ending", (Object)"testTwoTransactionsWithSameTwoParticipatingShards");
    }

    @Test
    public void testMultipleTransactionsWithMixedParticipatingShards() {
        String testName = "testMultipleTransactionsWithMixedParticipatingShards";
        LOG.info("{} starting", (Object)"testMultipleTransactionsWithMixedParticipatingShards");
        TestKit kit1 = new TestKit(ShardCommitCoordinationTest.getSystem());
        TestKit kit2 = new TestKit(ShardCommitCoordinationTest.getSystem());
        TestKit kit3 = new TestKit(ShardCommitCoordinationTest.getSystem());
        TestKit kit4 = new TestKit(ShardCommitCoordinationTest.getSystem());
        TestKit kit5 = new TestKit(ShardCommitCoordinationTest.getSystem());
        ShardIdentifier shardAId = ShardIdentifier.create((String)"shardA", (MemberName)MemberName.forName((String)"testMultipleTransactionsWithMixedParticipatingShards"), (String)"config");
        ShardIdentifier shardBId = ShardIdentifier.create((String)"shardB", (MemberName)MemberName.forName((String)"testMultipleTransactionsWithMixedParticipatingShards"), (String)"config");
        TestActorRef shardA = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().id(shardAId)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ShardTestKit.waitUntilLeader((ActorRef)shardA);
        TestActorRef shardB = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().id(shardBId)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ShardTestKit.waitUntilLeader((ActorRef)shardB);
        TransactionIdentifier txId1 = ShardCommitCoordinationTest.nextTransactionId();
        TransactionIdentifier txId2 = ShardCommitCoordinationTest.nextTransactionId();
        TransactionIdentifier txId3 = ShardCommitCoordinationTest.nextTransactionId();
        TransactionIdentifier txId4 = ShardCommitCoordinationTest.nextTransactionId();
        TransactionIdentifier txId5 = ShardCommitCoordinationTest.nextTransactionId();
        ImmutableSortedSet participatingShardNames1 = ImmutableSortedSet.of((Comparable)((Object)shardAId.getShardName()), (Comparable)((Object)shardBId.getShardName()));
        ImmutableSortedSet participatingShardNames2 = ImmutableSortedSet.of((Comparable)((Object)"shardX"), (Comparable)((Object)shardBId.getShardName()));
        shardA.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId3, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), (SortedSet<String>)participatingShardNames1), kit3.getRef());
        kit3.expectMsgClass(ReadyTransactionReply.class);
        shardA.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId4, TestModel.OUTER_LIST_PATH, (NormalizedNode)TestModel.outerMapNode(), (SortedSet<String>)participatingShardNames1), kit4.getRef());
        kit4.expectMsgClass(ReadyTransactionReply.class);
        shardA.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId5, TestModel.outerEntryPath(1), (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)1), (SortedSet<String>)participatingShardNames1), kit5.getRef());
        kit5.expectMsgClass(ReadyTransactionReply.class);
        shardB.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), (SortedSet<String>)participatingShardNames2), kit1.getRef());
        kit1.expectMsgClass(ReadyTransactionReply.class);
        shardB.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId2, TestModel.OUTER_LIST_PATH, (NormalizedNode)TestModel.outerMapNode(), (SortedSet<String>)participatingShardNames2), kit2.getRef());
        kit2.expectMsgClass(ReadyTransactionReply.class);
        shardB.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId5, TestModel.innerEntryPath(1, "one"), (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.INNER_LIST_QNAME, (QName)TestModel.NAME_QNAME, (Object)"one"), (SortedSet<String>)participatingShardNames1), kit5.getRef());
        kit5.expectMsgClass(ReadyTransactionReply.class);
        shardB.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId4, TestModel.innerMapPath(1), (NormalizedNode)TestModel.innerNode(new String[0]), (SortedSet<String>)participatingShardNames1), kit4.getRef());
        kit4.expectMsgClass(ReadyTransactionReply.class);
        shardB.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId3, TestModel.outerEntryPath(1), (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)1), (SortedSet<String>)participatingShardNames1), kit3.getRef());
        kit3.expectMsgClass(ReadyTransactionReply.class);
        shardA.tell(new CanCommitTransaction(txId3, 13).toSerializable(), kit3.getRef());
        kit3.expectMsgClass(CanCommitTransactionReply.class);
        shardB.tell(new CanCommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CanCommitTransactionReply.class);
        shardB.tell(new CanCommitTransaction(txId3, 13).toSerializable(), kit3.getRef());
        kit3.expectNoMessage(Duration.ofMillis(100L));
        shardB.tell(new CanCommitTransaction(txId4, 13).toSerializable(), kit4.getRef());
        kit4.expectNoMessage(Duration.ofMillis(100L));
        shardB.tell(new CanCommitTransaction(txId5, 13).toSerializable(), kit5.getRef());
        kit5.expectNoMessage(Duration.ofMillis(100L));
        shardB.tell(new CommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CommitTransactionReply.class);
        shardB.tell(new CanCommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CanCommitTransactionReply.class);
        shardB.tell(new CommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CommitTransactionReply.class);
        kit3.expectMsgClass(CanCommitTransactionReply.class);
        shardA.tell(new CommitTransaction(txId3, 13).toSerializable(), kit3.getRef());
        kit3.expectMsgClass(CommitTransactionReply.class);
        shardB.tell(new CommitTransaction(txId3, 13).toSerializable(), kit3.getRef());
        kit3.expectMsgClass(CommitTransactionReply.class);
        kit4.expectMsgClass(CanCommitTransactionReply.class);
        shardA.tell(new CanCommitTransaction(txId4, 13).toSerializable(), kit4.getRef());
        kit4.expectMsgClass(CanCommitTransactionReply.class);
        shardA.tell(new CommitTransaction(txId4, 13).toSerializable(), kit4.getRef());
        kit4.expectMsgClass(CommitTransactionReply.class);
        shardB.tell(new CommitTransaction(txId4, 13).toSerializable(), kit4.getRef());
        kit4.expectMsgClass(CommitTransactionReply.class);
        kit5.expectMsgClass(CanCommitTransactionReply.class);
        shardA.tell(new CanCommitTransaction(txId5, 13).toSerializable(), kit5.getRef());
        kit5.expectMsgClass(CanCommitTransactionReply.class);
        shardA.tell(new CommitTransaction(txId5, 13).toSerializable(), kit5.getRef());
        kit5.expectMsgClass(CommitTransactionReply.class);
        shardB.tell(new CommitTransaction(txId5, 13).toSerializable(), kit5.getRef());
        kit5.expectMsgClass(CommitTransactionReply.class);
        ShardCommitCoordinationTest.verifyOuterListEntry((TestActorRef<Shard>)shardA, 1);
        ShardCommitCoordinationTest.verifyInnerListEntry((TestActorRef<Shard>)shardB, 1, "one");
        LOG.info("{} ending", (Object)"testMultipleTransactionsWithMixedParticipatingShards");
    }

    @Test
    public void testTwoTransactionsWithOneCommonParticipatingShard1() {
        String testName = "testTwoTransactionsWithOneCommonParticipatingShard1";
        LOG.info("{} starting", (Object)"testTwoTransactionsWithOneCommonParticipatingShard1");
        TestKit kit1 = new TestKit(ShardCommitCoordinationTest.getSystem());
        TestKit kit2 = new TestKit(ShardCommitCoordinationTest.getSystem());
        ShardIdentifier shardAId = ShardIdentifier.create((String)"shardA", (MemberName)MemberName.forName((String)"testTwoTransactionsWithOneCommonParticipatingShard1"), (String)"config");
        ShardIdentifier shardBId = ShardIdentifier.create((String)"shardB", (MemberName)MemberName.forName((String)"testTwoTransactionsWithOneCommonParticipatingShard1"), (String)"config");
        ShardIdentifier shardCId = ShardIdentifier.create((String)"shardC", (MemberName)MemberName.forName((String)"testTwoTransactionsWithOneCommonParticipatingShard1"), (String)"config");
        TestActorRef shardA = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().id(shardAId)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ShardTestKit.waitUntilLeader((ActorRef)shardA);
        TestActorRef shardB = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().id(shardBId)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ShardTestKit.waitUntilLeader((ActorRef)shardB);
        TestActorRef shardC = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().id(shardCId)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ShardTestKit.waitUntilLeader((ActorRef)shardC);
        TransactionIdentifier txId1 = ShardCommitCoordinationTest.nextTransactionId();
        TransactionIdentifier txId2 = ShardCommitCoordinationTest.nextTransactionId();
        ImmutableSortedSet participatingShardNames1 = ImmutableSortedSet.of((Comparable)((Object)shardAId.getShardName()), (Comparable)((Object)shardCId.getShardName()));
        ImmutableSortedSet participatingShardNames2 = ImmutableSortedSet.of((Comparable)((Object)shardBId.getShardName()), (Comparable)((Object)shardCId.getShardName()));
        shardA.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), (SortedSet<String>)participatingShardNames1), kit1.getRef());
        kit1.expectMsgClass(ReadyTransactionReply.class);
        shardB.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), (SortedSet<String>)participatingShardNames2), kit2.getRef());
        kit2.expectMsgClass(ReadyTransactionReply.class);
        shardC.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), (SortedSet<String>)participatingShardNames2), kit2.getRef());
        kit2.expectMsgClass(ReadyTransactionReply.class);
        shardC.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId1, TestModel.OUTER_LIST_PATH, (NormalizedNode)TestModel.outerNode(1), (SortedSet<String>)participatingShardNames1), kit1.getRef());
        kit1.expectMsgClass(ReadyTransactionReply.class);
        shardA.tell(new CanCommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CanCommitTransactionReply.class);
        shardB.tell(new CanCommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CanCommitTransactionReply.class);
        shardC.tell(new CanCommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectNoMessage(Duration.ofMillis(100L));
        shardC.tell(new CanCommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CanCommitTransactionReply.class);
        shardB.tell(new CommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CommitTransactionReply.class);
        shardC.tell(new CommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CommitTransactionReply.class);
        kit1.expectMsgClass(CanCommitTransactionReply.class);
        shardA.tell(new CommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CommitTransactionReply.class);
        shardC.tell(new CommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CommitTransactionReply.class);
        ShardCommitCoordinationTest.verifyOuterListEntry((TestActorRef<Shard>)shardC, 1);
        LOG.info("{} ending", (Object)"testTwoTransactionsWithOneCommonParticipatingShard1");
    }

    @Test
    public void testTwoTransactionsWithOneCommonParticipatingShard2() {
        String testName = "testTwoTransactionsWithOneCommonParticipatingShard2";
        LOG.info("{} starting", (Object)"testTwoTransactionsWithOneCommonParticipatingShard2");
        TestKit kit1 = new TestKit(ShardCommitCoordinationTest.getSystem());
        TestKit kit2 = new TestKit(ShardCommitCoordinationTest.getSystem());
        ShardIdentifier shardAId = ShardIdentifier.create((String)"shardA", (MemberName)MemberName.forName((String)"testTwoTransactionsWithOneCommonParticipatingShard2"), (String)"config");
        ShardIdentifier shardBId = ShardIdentifier.create((String)"shardB", (MemberName)MemberName.forName((String)"testTwoTransactionsWithOneCommonParticipatingShard2"), (String)"config");
        ShardIdentifier shardCId = ShardIdentifier.create((String)"shardC", (MemberName)MemberName.forName((String)"testTwoTransactionsWithOneCommonParticipatingShard2"), (String)"config");
        TestActorRef shardA = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().id(shardAId)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ShardTestKit.waitUntilLeader((ActorRef)shardA);
        TestActorRef shardB = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().id(shardBId)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ShardTestKit.waitUntilLeader((ActorRef)shardB);
        TestActorRef shardC = this.actorFactory.createTestActor(((Shard.Builder)this.newShardBuilder().id(shardCId)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ShardTestKit.waitUntilLeader((ActorRef)shardC);
        TransactionIdentifier txId1 = ShardCommitCoordinationTest.nextTransactionId();
        TransactionIdentifier txId2 = ShardCommitCoordinationTest.nextTransactionId();
        ImmutableSortedSet participatingShardNames1 = ImmutableSortedSet.of((Comparable)((Object)shardAId.getShardName()), (Comparable)((Object)shardBId.getShardName()));
        ImmutableSortedSet participatingShardNames2 = ImmutableSortedSet.of((Comparable)((Object)shardBId.getShardName()), (Comparable)((Object)shardCId.getShardName()));
        shardA.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId1, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), (SortedSet<String>)participatingShardNames1), kit1.getRef());
        kit1.expectMsgClass(ReadyTransactionReply.class);
        shardB.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), (SortedSet<String>)participatingShardNames2), kit2.getRef());
        kit2.expectMsgClass(ReadyTransactionReply.class);
        shardB.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId1, TestModel.OUTER_LIST_PATH, (NormalizedNode)TestModel.outerNode(1), (SortedSet<String>)participatingShardNames1), kit1.getRef());
        kit1.expectMsgClass(ReadyTransactionReply.class);
        shardC.tell((Object)ShardCommitCoordinationTest.newReadyBatchedModifications(txId2, TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME), (SortedSet<String>)participatingShardNames2), kit2.getRef());
        kit2.expectMsgClass(ReadyTransactionReply.class);
        shardA.tell(new CanCommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CanCommitTransactionReply.class);
        shardB.tell(new CanCommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectNoMessage(Duration.ofMillis(100L));
        shardB.tell(new CanCommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CanCommitTransactionReply.class);
        shardC.tell(new CanCommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CanCommitTransactionReply.class);
        shardB.tell(new CommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CommitTransactionReply.class);
        shardC.tell(new CommitTransaction(txId2, 13).toSerializable(), kit2.getRef());
        kit2.expectMsgClass(CommitTransactionReply.class);
        kit1.expectMsgClass(CanCommitTransactionReply.class);
        shardA.tell(new CommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CommitTransactionReply.class);
        shardB.tell(new CommitTransaction(txId1, 13).toSerializable(), kit1.getRef());
        kit1.expectMsgClass(CommitTransactionReply.class);
        ShardCommitCoordinationTest.verifyOuterListEntry((TestActorRef<Shard>)shardB, 1);
        LOG.info("{} ending", (Object)"testTwoTransactionsWithOneCommonParticipatingShard2");
    }

    static void verifyInnerListEntry(TestActorRef<Shard> shard, int outerID, String innerID) {
        YangInstanceIdentifier path = TestModel.innerEntryPath(outerID, innerID);
        NormalizedNode innerListEntry = ShardCommitCoordinationTest.readStore(shard, path);
        Assert.assertNotNull((String)(path + " not found"), (Object)innerListEntry);
    }
}

