/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.datastore.OperationCallback;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;

@Deprecated(since="9.0.0", forRemoval=true)
final class TransactionRateLimitingCallback
implements OperationCallback {
    private static Ticker TICKER = Ticker.systemTicker();
    private final Timer commitTimer;
    private long startTime;
    private long elapsedTime;
    private volatile State state = State.STOPPED;

    TransactionRateLimitingCallback(ActorUtils actorUtils) {
        this.commitTimer = actorUtils.getOperationTimer("commit");
    }

    @Override
    public void run() {
        Preconditions.checkState((this.state == State.STOPPED ? 1 : 0) != 0, (Object)"state is not STOPPED");
        this.resume();
    }

    @Override
    public void pause() {
        if (this.state == State.RUNNING) {
            this.elapsedTime += TICKER.read() - this.startTime;
            this.state = State.PAUSED;
        }
    }

    @Override
    public void resume() {
        if (this.state != State.RUNNING) {
            this.startTime = TICKER.read();
            this.state = State.RUNNING;
        }
    }

    @Override
    public void success() {
        Preconditions.checkState((this.state != State.STOPPED ? 1 : 0) != 0, (Object)"state is STOPPED");
        this.pause();
        this.commitTimer.update(this.elapsedTime, TimeUnit.NANOSECONDS);
        this.state = State.STOPPED;
    }

    @Override
    public void failure() {
    }

    @VisibleForTesting
    static void setTicker(Ticker ticker) {
        TICKER = ticker;
    }

    private static enum State {
        STOPPED,
        RUNNING,
        PAUSED;

    }
}

