/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.codahale.metrics.Timer;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.datastore.TransactionRateLimitingCallback;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;

@Deprecated(since="9.0.0", forRemoval=true)
@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class TransactionRateLimitingCallbackTest {
    @Mock
    ActorUtils mockContext;
    @Mock
    Timer mockTimer;
    @Mock
    Ticker mockTicker;
    TransactionRateLimitingCallback callback;

    @Before
    public void setUp() {
        ((ActorUtils)Mockito.doReturn((Object)this.mockTimer).when((Object)this.mockContext)).getOperationTimer("commit");
        this.callback = new TransactionRateLimitingCallback(this.mockContext);
        TransactionRateLimitingCallback.setTicker(this.mockTicker);
    }

    @Test
    public void testSuccessWithoutPause() {
        ((Ticker)Mockito.doReturn((Object)1L).doReturn((Object)201L).when((Object)this.mockTicker)).read();
        this.callback.run();
        this.callback.success();
        ((Timer)Mockito.verify((Object)this.mockTimer)).update(200L, TimeUnit.NANOSECONDS);
    }

    @Test
    public void testSuccessWithPause() {
        ((Ticker)Mockito.doReturn((Object)1L).doReturn((Object)201L).doReturn((Object)301L).doReturn((Object)351L).when((Object)this.mockTicker)).read();
        this.callback.run();
        this.callback.pause();
        this.callback.pause();
        this.callback.resume();
        this.callback.resume();
        this.callback.success();
        ((Timer)Mockito.verify((Object)this.mockTimer)).update(250L, TimeUnit.NANOSECONDS);
    }

    @Test
    public void testFailure() {
        ((Ticker)Mockito.doReturn((Object)1L).when((Object)this.mockTicker)).read();
        this.callback.run();
        this.callback.failure();
        ((Timer)Mockito.verify((Object)this.mockTimer, (VerificationMode)Mockito.never())).update(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }

    @Test
    public void testSuccessWithoutRun() {
        IllegalStateException ex = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, this.callback::success);
        ((Timer)Mockito.verify((Object)this.mockTimer, (VerificationMode)Mockito.never())).update(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }
}

