/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;

public class ShardSnapshotStateTest {
    @Test
    public void testSerialization() {
        ContainerNode expectedNode = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        ShardSnapshotState expected = new ShardSnapshotState((ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot((NormalizedNode)expectedNode));
        ShardSnapshotState cloned = (ShardSnapshotState)SerializationUtils.clone((Serializable)expected);
        Assert.assertNotNull((String)"getSnapshot is null", (Object)cloned.getSnapshot());
        Assert.assertEquals((String)"getSnapshot type", MetadataShardDataTreeSnapshot.class, cloned.getSnapshot().getClass());
        Assert.assertEquals((String)"getRootNode", Optional.of(expectedNode), (Object)((MetadataShardDataTreeSnapshot)cloned.getSnapshot()).getRootNode());
    }
}

