/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import akka.actor.ActorRef;
import akka.actor.Status;
import akka.actor.Terminated;
import akka.testkit.javadsl.TestKit;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardManagerSnapshot;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManagerGetSnapshotReplyActor;
import org.opendaylight.controller.cluster.raft.client.messages.GetSnapshotReply;
import org.opendaylight.controller.cluster.raft.persisted.ByteState;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import scala.concurrent.duration.FiniteDuration;

public class ShardManagerGetSnapshotReplyActorTest
extends AbstractActorTest {
    private static final MemberName MEMBER_1 = MemberName.forName((String)"member-1");

    @Test
    public void testSuccess() {
        TestKit kit = new TestKit(ShardManagerGetSnapshotReplyActorTest.getSystem());
        List<String> shardList = Arrays.asList("shard1", "shard2", "shard3");
        ShardManagerSnapshot shardManagerSnapshot = new ShardManagerSnapshot(shardList);
        ActorRef replyActor = ShardManagerGetSnapshotReplyActorTest.getSystem().actorOf(ShardManagerGetSnapshotReplyActor.props(shardList, (String)"config", (ShardManagerSnapshot)shardManagerSnapshot, (ActorRef)kit.getRef(), (String)"shard-manager", (FiniteDuration)FiniteDuration.create((long)100L, (TimeUnit)TimeUnit.SECONDS)), "testSuccess");
        kit.watch(replyActor);
        ByteState shard1SnapshotState = ByteState.of((byte[])new byte[]{1, 2, 3});
        replyActor.tell((Object)new GetSnapshotReply(ShardIdentifier.create((String)"shard1", (MemberName)MEMBER_1, (String)"config").toString(), Snapshot.create((Snapshot.State)shard1SnapshotState, Collections.emptyList(), (long)2L, (long)1L, (long)2L, (long)1L, (long)1L, (String)"member-1", null)), ActorRef.noSender());
        ByteState shard2SnapshotState = ByteState.of((byte[])new byte[]{4, 5, 6});
        replyActor.tell((Object)new GetSnapshotReply(ShardIdentifier.create((String)"shard2", (MemberName)MEMBER_1, (String)"config").toString(), Snapshot.create((Snapshot.State)shard2SnapshotState, Collections.emptyList(), (long)2L, (long)1L, (long)2L, (long)1L, (long)1L, (String)"member-1", null)), ActorRef.noSender());
        kit.expectNoMessage(Duration.ofMillis(500L));
        ByteState shard3SnapshotState = ByteState.of((byte[])new byte[]{7, 8, 9});
        replyActor.tell((Object)new GetSnapshotReply(ShardIdentifier.create((String)"shard3", (MemberName)MEMBER_1, (String)"config").toString(), Snapshot.create((Snapshot.State)shard3SnapshotState, Collections.emptyList(), (long)2L, (long)1L, (long)2L, (long)1L, (long)1L, (String)"member-1", null)), ActorRef.noSender());
        DatastoreSnapshot datastoreSnapshot = (DatastoreSnapshot)kit.expectMsgClass(DatastoreSnapshot.class);
        Assert.assertEquals((String)"getType", (Object)"config", (Object)datastoreSnapshot.getType());
        Assert.assertEquals((String)"getShardManagerSnapshot", (Object)shardManagerSnapshot.getShardList(), (Object)datastoreSnapshot.getShardManagerSnapshot().getShardList());
        List shardSnapshots = datastoreSnapshot.getShardSnapshots();
        Assert.assertEquals((String)"ShardSnapshot size", (long)3L, (long)shardSnapshots.size());
        Assert.assertEquals((String)"ShardSnapshot 1 getName", (Object)"shard1", (Object)((DatastoreSnapshot.ShardSnapshot)shardSnapshots.get(0)).getName());
        Assert.assertEquals((String)"ShardSnapshot 1 getSnapshot", (Object)shard1SnapshotState, (Object)((DatastoreSnapshot.ShardSnapshot)shardSnapshots.get(0)).getSnapshot().getState());
        Assert.assertEquals((String)"ShardSnapshot 2 getName", (Object)"shard2", (Object)((DatastoreSnapshot.ShardSnapshot)shardSnapshots.get(1)).getName());
        Assert.assertEquals((String)"ShardSnapshot 2 getSnapshot", (Object)shard2SnapshotState, (Object)((DatastoreSnapshot.ShardSnapshot)shardSnapshots.get(1)).getSnapshot().getState());
        Assert.assertEquals((String)"ShardSnapshot 3 getName", (Object)"shard3", (Object)((DatastoreSnapshot.ShardSnapshot)shardSnapshots.get(2)).getName());
        Assert.assertEquals((String)"ShardSnapshot 3 getSnapshot", (Object)shard3SnapshotState, (Object)((DatastoreSnapshot.ShardSnapshot)shardSnapshots.get(2)).getSnapshot().getState());
        kit.expectMsgClass(Terminated.class);
    }

    @Test
    public void testGetSnapshotFailureReply() {
        TestKit kit = new TestKit(ShardManagerGetSnapshotReplyActorTest.getSystem());
        ActorRef replyActor = ShardManagerGetSnapshotReplyActorTest.getSystem().actorOf(ShardManagerGetSnapshotReplyActor.props(Arrays.asList("shard1", "shard2"), (String)"config", null, (ActorRef)kit.getRef(), (String)"shard-manager", (FiniteDuration)FiniteDuration.create((long)100L, (TimeUnit)TimeUnit.SECONDS)), "testGetSnapshotFailureReply");
        kit.watch(replyActor);
        replyActor.tell((Object)new GetSnapshotReply(ShardIdentifier.create((String)"shard1", (MemberName)MEMBER_1, (String)"config").toString(), Snapshot.create((Snapshot.State)ByteState.of((byte[])new byte[]{1, 2, 3}), Collections.emptyList(), (long)2L, (long)1L, (long)2L, (long)1L, (long)1L, (String)"member-1", null)), ActorRef.noSender());
        replyActor.tell((Object)new Status.Failure((Throwable)new RuntimeException()), ActorRef.noSender());
        kit.expectMsgClass(Status.Failure.class);
        kit.expectTerminated(replyActor);
    }

    @Test
    public void testGetSnapshotTimeout() {
        TestKit kit = new TestKit(ShardManagerGetSnapshotReplyActorTest.getSystem());
        ActorRef replyActor = ShardManagerGetSnapshotReplyActorTest.getSystem().actorOf(ShardManagerGetSnapshotReplyActor.props(Arrays.asList("shard1"), (String)"config", null, (ActorRef)kit.getRef(), (String)"shard-manager", (FiniteDuration)FiniteDuration.create((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)), "testGetSnapshotTimeout");
        kit.watch(replyActor);
        Status.Failure failure = (Status.Failure)kit.expectMsgClass(Status.Failure.class);
        Assert.assertEquals((String)"Failure cause type", TimeoutException.class, failure.cause().getClass());
        kit.expectTerminated(replyActor);
    }
}

