/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import akka.dispatch.MessageDispatcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.common.actor.Dispatchers;

public class DispatchersTest {
    @Test
    public void testGetDefaultDispatcherPath() {
        akka.dispatch.Dispatchers mockDispatchers = (akka.dispatch.Dispatchers)Mockito.mock(akka.dispatch.Dispatchers.class);
        ((akka.dispatch.Dispatchers)Mockito.doReturn((Object)false).when((Object)mockDispatchers)).hasDispatcher(ArgumentMatchers.anyString());
        Dispatchers dispatchers = new Dispatchers(mockDispatchers);
        for (Dispatchers.DispatcherType type : Dispatchers.DispatcherType.values()) {
            Assert.assertEquals((Object)"akka.actor.default-dispatcher", (Object)dispatchers.getDispatcherPath(type));
        }
    }

    @Test
    public void testGetDefaultDispatcher() {
        akka.dispatch.Dispatchers mockDispatchers = (akka.dispatch.Dispatchers)Mockito.mock(akka.dispatch.Dispatchers.class);
        MessageDispatcher mockGlobalDispatcher = (MessageDispatcher)Mockito.mock(MessageDispatcher.class);
        ((akka.dispatch.Dispatchers)Mockito.doReturn((Object)false).when((Object)mockDispatchers)).hasDispatcher(ArgumentMatchers.anyString());
        ((akka.dispatch.Dispatchers)Mockito.doReturn((Object)mockGlobalDispatcher).when((Object)mockDispatchers)).defaultGlobalDispatcher();
        Dispatchers dispatchers = new Dispatchers(mockDispatchers);
        for (Dispatchers.DispatcherType type : Dispatchers.DispatcherType.values()) {
            Assert.assertEquals((Object)mockGlobalDispatcher, (Object)dispatchers.getDispatcher(type));
        }
    }

    @Test
    public void testGetDispatcherPath() {
        akka.dispatch.Dispatchers mockDispatchers = (akka.dispatch.Dispatchers)Mockito.mock(akka.dispatch.Dispatchers.class);
        ((akka.dispatch.Dispatchers)Mockito.doReturn((Object)true).when((Object)mockDispatchers)).hasDispatcher(ArgumentMatchers.anyString());
        Dispatchers dispatchers = new Dispatchers(mockDispatchers);
        Assert.assertEquals((Object)"client-dispatcher", (Object)dispatchers.getDispatcherPath(Dispatchers.DispatcherType.Client));
        Assert.assertEquals((Object)"txn-dispatcher", (Object)dispatchers.getDispatcherPath(Dispatchers.DispatcherType.Transaction));
        Assert.assertEquals((Object)"shard-dispatcher", (Object)dispatchers.getDispatcherPath(Dispatchers.DispatcherType.Shard));
        Assert.assertEquals((Object)"notification-dispatcher", (Object)dispatchers.getDispatcherPath(Dispatchers.DispatcherType.Notification));
    }

    @Test
    public void testGetDispatcher() {
        akka.dispatch.Dispatchers mockDispatchers = (akka.dispatch.Dispatchers)Mockito.mock(akka.dispatch.Dispatchers.class);
        MessageDispatcher mockDispatcher = (MessageDispatcher)Mockito.mock(MessageDispatcher.class);
        ((akka.dispatch.Dispatchers)Mockito.doReturn((Object)true).when((Object)mockDispatchers)).hasDispatcher(ArgumentMatchers.anyString());
        ((akka.dispatch.Dispatchers)Mockito.doReturn((Object)mockDispatcher).when((Object)mockDispatchers)).lookup(ArgumentMatchers.anyString());
        Dispatchers dispatchers = new Dispatchers(mockDispatchers);
        Assert.assertEquals((Object)"client-dispatcher", (Object)dispatchers.getDispatcherPath(Dispatchers.DispatcherType.Client));
        Assert.assertEquals((Object)"txn-dispatcher", (Object)dispatchers.getDispatcherPath(Dispatchers.DispatcherType.Transaction));
        Assert.assertEquals((Object)"shard-dispatcher", (Object)dispatchers.getDispatcherPath(Dispatchers.DispatcherType.Shard));
        Assert.assertEquals((Object)"notification-dispatcher", (Object)dispatchers.getDispatcherPath(Dispatchers.DispatcherType.Notification));
    }
}

