/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.utils.NormalizedNodeAggregator;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataStore;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public class NormalizedNodeAggregatorTest {
    @Test
    public void testAggregate() throws InterruptedException, ExecutionException, DataValidationFailedException {
        EffectiveModelContext schemaContext = SchemaContextHelper.full();
        NormalizedNode expectedNode1 = ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).build();
        NormalizedNode expectedNode2 = ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CarsModel.CARS_QNAME)).build();
        Optional optional = NormalizedNodeAggregator.aggregate((YangInstanceIdentifier)YangInstanceIdentifier.of(), (List)ImmutableList.of(Optional.of(NormalizedNodeAggregatorTest.getRootNode(expectedNode1, schemaContext)), Optional.of(NormalizedNodeAggregatorTest.getRootNode(expectedNode2, schemaContext))), (EffectiveModelContext)schemaContext, (LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION);
        NormalizedNode normalizedNode = (NormalizedNode)optional.orElseThrow();
        Assert.assertTrue((String)"Expect value to be a Collection", (boolean)(normalizedNode.body() instanceof Collection));
        Collection collection = (Collection)normalizedNode.body();
        for (NormalizedNode node : collection) {
            Assert.assertTrue((String)("Expected " + node + " to be a ContainerNode"), (boolean)(node instanceof ContainerNode));
        }
        Assert.assertTrue((String)("Child with QName = " + TestModel.TEST_QNAME + " not found"), (NormalizedNodeAggregatorTest.findChildWithQName(collection, TestModel.TEST_QNAME) != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)expectedNode1, (Object)NormalizedNodeAggregatorTest.findChildWithQName(collection, TestModel.TEST_QNAME));
        Assert.assertTrue((String)("Child with QName = " + CarsModel.BASE_QNAME + " not found"), (NormalizedNodeAggregatorTest.findChildWithQName(collection, CarsModel.BASE_QNAME) != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)expectedNode2, (Object)NormalizedNodeAggregatorTest.findChildWithQName(collection, CarsModel.BASE_QNAME));
    }

    public static NormalizedNode getRootNode(NormalizedNode moduleNode, EffectiveModelContext schemaContext) throws ExecutionException, InterruptedException {
        try (InMemoryDOMDataStore store = new InMemoryDOMDataStore("test", Executors.newSingleThreadExecutor());){
            store.onModelContextUpdated(schemaContext);
            DOMStoreWriteTransaction writeTransaction = store.newWriteOnlyTransaction();
            writeTransaction.merge(YangInstanceIdentifier.of((QName)moduleNode.name().getNodeType()), moduleNode);
            DOMStoreThreePhaseCommitCohort ready = writeTransaction.ready();
            ready.canCommit().get();
            ready.preCommit().get();
            ready.commit().get();
            DOMStoreReadTransaction readTransaction = store.newReadOnlyTransaction();
            NormalizedNode normalizedNode = (NormalizedNode)((Optional)readTransaction.read(YangInstanceIdentifier.of()).get()).orElseThrow();
            return normalizedNode;
        }
    }

    public static NormalizedNode findChildWithQName(Collection<NormalizedNode> collection, QName qname) {
        for (NormalizedNode node : collection) {
            if (!node.name().getNodeType().equals((Object)qname)) continue;
            return node;
        }
        return null;
    }
}

