/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.annotations.Beta;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.cluster.datastore.DatastoreSnapshotRestore;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshotList;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
public final class DefaultDatastoreSnapshotRestore
implements DatastoreSnapshotRestore {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDatastoreSnapshotRestore.class);
    private final Map<String, DatastoreSnapshot> datastoreSnapshots = new ConcurrentHashMap<String, DatastoreSnapshot>();
    private final String restoreDirectoryPath;

    public DefaultDatastoreSnapshotRestore() {
        this("./clustered-datastore-restore");
    }

    public DefaultDatastoreSnapshotRestore(String restoreDirectoryPath) {
        this.restoreDirectoryPath = Objects.requireNonNull(restoreDirectoryPath);
    }

    @Override
    public Optional<DatastoreSnapshot> getAndRemove(String datastoreType) {
        return Optional.ofNullable(this.datastoreSnapshots.remove(datastoreType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    void activate() {
        File restoreDirectoryFile = new File(this.restoreDirectoryPath);
        String[] files = restoreDirectoryFile.list();
        if (files == null || files.length == 0) {
            LOG.debug("Restore directory {} does not exist or is empty", (Object)restoreDirectoryFile);
            return;
        }
        if (files.length > 1) {
            LOG.error("Found {} files in clustered datastore restore directory {} - expected 1. No restore will be attempted", (Object)files.length, (Object)restoreDirectoryFile);
            return;
        }
        File restoreFile = new File(restoreDirectoryFile, files[0]);
        LOG.info("Clustered datastore will be restored from file {}", (Object)restoreFile);
        try (FileInputStream fis = new FileInputStream(restoreFile);){
            DatastoreSnapshotList snapshots = DefaultDatastoreSnapshotRestore.deserialize(fis);
            LOG.debug("Deserialized {} snapshots", (Object)snapshots.size());
            for (DatastoreSnapshot snapshot : snapshots) {
                this.datastoreSnapshots.put(snapshot.getType(), snapshot);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.error("Error reading clustered datastore restore file {}", (Object)restoreFile, (Object)e);
        }
        finally {
            if (!restoreFile.delete()) {
                LOG.error("Could not delete clustered datastore restore file {}", (Object)restoreFile);
            }
        }
    }

    private static DatastoreSnapshotList deserialize(InputStream inputStream) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(inputStream);){
            DatastoreSnapshotList datastoreSnapshotList = (DatastoreSnapshotList)ois.readObject();
            return datastoreSnapshotList;
        }
    }
}

