/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;

abstract class AbstractDataTreeCandidateNode
implements DataTreeCandidateNode {
    private final @NonNull ModificationType type;

    protected AbstractDataTreeCandidateNode(ModificationType type) {
        this.type = Objects.requireNonNull(type);
    }

    public final DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument identifier) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public final ModificationType modificationType() {
        return this.type;
    }

    public final NormalizedNode dataBefore() {
        throw new UnsupportedOperationException("Before-image not available after serialization");
    }

    static DataTreeCandidateNode createUnmodified() {
        return new AbstractDataTreeCandidateNode(ModificationType.UNMODIFIED){

            public YangInstanceIdentifier.PathArgument name() {
                throw new UnsupportedOperationException("Root node does not have an identifier");
            }

            public NormalizedNode dataAfter() {
                throw new UnsupportedOperationException("After-image not available after serialization");
            }

            public Collection<DataTreeCandidateNode> childNodes() {
                throw new UnsupportedOperationException("Children not available after serialization");
            }
        };
    }
}

