/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.persisted.CommitTransactionPayload;
import org.opendaylight.controller.cluster.io.ChunkedByteArray;

final class CT
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private CommitTransactionPayload payload;

    public CT() {
    }

    CT(CommitTransactionPayload payload) {
        this.payload = Objects.requireNonNull(payload);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.payload.size());
        this.payload.writeBytes(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int length = in.readInt();
        if (length < 0) {
            throw new StreamCorruptedException("Invalid payload length " + length);
        }
        if (length < CommitTransactionPayload.MAX_ARRAY_SIZE) {
            byte[] serialized = new byte[length];
            in.readFully(serialized);
            this.payload = new CommitTransactionPayload.Simple(serialized);
        } else {
            this.payload = new CommitTransactionPayload.Chunked(ChunkedByteArray.readFrom((ObjectInput)in, (int)length, (int)CommitTransactionPayload.MAX_ARRAY_SIZE));
        }
    }

    private Object readResolve() {
        return Verify.verifyNotNull((Object)this.payload);
    }
}

