/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ForwardingObject;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.cluster.datastore.node.utils.transformer.ReusableNormalizedNodePruner;
import org.opendaylight.controller.cluster.datastore.util.AbstractDataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.api.SchemaValidationFailedException;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PruningDataTreeModification
extends ForwardingObject
implements DataTreeModification {
    private static final Logger LOG = LoggerFactory.getLogger(PruningDataTreeModification.class);
    private final ReusableNormalizedNodePruner pruner;
    private final DataTree dataTree;
    private DataTreeModification delegate;

    PruningDataTreeModification(DataTreeModification delegate, DataTree dataTree, ReusableNormalizedNodePruner pruner) {
        this.delegate = Objects.requireNonNull(delegate);
        this.dataTree = Objects.requireNonNull(dataTree);
        this.pruner = Objects.requireNonNull(pruner);
    }

    protected final DataTreeModification delegate() {
        return this.delegate;
    }

    public final EffectiveModelContext modelContext() {
        return this.delegate.modelContext();
    }

    public final void delete(YangInstanceIdentifier path) {
        try {
            this.delegate.delete(path);
        }
        catch (SchemaValidationFailedException e) {
            LOG.warn("Node at path : {} does not exist ignoring delete", (Object)path);
        }
    }

    final void pruneAndMergeNode(YangInstanceIdentifier path, NormalizedNode data) {
        NormalizedNode pruned = this.pruneNormalizedNode(path, data);
        if (pruned != null) {
            this.delegate.merge(path, pruned);
        }
    }

    final void pruneAndWriteNode(YangInstanceIdentifier path, NormalizedNode data) {
        NormalizedNode pruned = this.pruneNormalizedNode(path, data);
        if (pruned != null) {
            this.delegate.write(path, pruned);
        }
    }

    public final void ready() {
        try {
            this.delegate.ready();
        }
        catch (SchemaValidationFailedException e) {
            DataTreeModification newModification = this.dataTree.takeSnapshot().newModification();
            this.delegate.applyToCursor((DataTreeModificationCursor)new PruningDataTreeModificationCursor(newModification, this));
            this.delegate = newModification;
            this.delegate.ready();
        }
    }

    public final void applyToCursor(DataTreeModificationCursor dataTreeModificationCursor) {
        this.delegate.applyToCursor(dataTreeModificationCursor);
    }

    public final Optional<NormalizedNode> readNode(YangInstanceIdentifier yangInstanceIdentifier) {
        return this.delegate.readNode(yangInstanceIdentifier);
    }

    public final DataTreeModification newModification() {
        return this.createNew(this.delegate.newModification(), this.dataTree, this.pruner.duplicate());
    }

    @VisibleForTesting
    final NormalizedNode pruneNormalizedNode(YangInstanceIdentifier path, NormalizedNode input) {
        this.pruner.initializeForPath(path);
        try {
            NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)this.pruner).write(input);
        }
        catch (IOException ioe) {
            LOG.error("Unexpected IOException when pruning normalizedNode", (Throwable)ioe);
            return null;
        }
        return this.pruner.getResult().orElse(null);
    }

    abstract PruningDataTreeModification createNew(DataTreeModification var1, DataTree var2, ReusableNormalizedNodePruner var3);

    private static final class PruningDataTreeModificationCursor
    extends AbstractDataTreeModificationCursor {
        private final DataTreeModification toModification;
        private final PruningDataTreeModification pruningModification;

        PruningDataTreeModificationCursor(DataTreeModification toModification, PruningDataTreeModification pruningModification) {
            this.toModification = toModification;
            this.pruningModification = pruningModification;
        }

        public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode data) {
            YangInstanceIdentifier path = this.current().node(child);
            NormalizedNode prunedNode = this.pruningModification.pruneNormalizedNode(path, data);
            if (prunedNode != null) {
                this.toModification.write(path, prunedNode);
            }
        }

        public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode data) {
            YangInstanceIdentifier path = this.current().node(child);
            NormalizedNode prunedNode = this.pruningModification.pruneNormalizedNode(path, data);
            if (prunedNode != null) {
                this.toModification.merge(path, prunedNode);
            }
        }

        public void delete(YangInstanceIdentifier.PathArgument child) {
            try {
                this.toModification.delete(this.current().node(child));
            }
            catch (SchemaValidationFailedException schemaValidationFailedException) {
                // empty catch block
            }
        }
    }

    public static final class Reactive
    extends PruningDataTreeModification {
        public Reactive(DataTreeModification delegate, DataTree dataTree, ReusableNormalizedNodePruner pruner) {
            super(delegate, dataTree, pruner);
        }

        public void merge(YangInstanceIdentifier path, NormalizedNode data) {
            if (path.isEmpty()) {
                this.pruneAndMergeNode(path, data);
                return;
            }
            try {
                this.delegate().merge(path, data);
            }
            catch (SchemaValidationFailedException e) {
                LOG.warn("Node at path {} was pruned during merge due to validation error: {}", (Object)path, (Object)e.getMessage());
                this.pruneAndMergeNode(path, data);
            }
        }

        public void write(YangInstanceIdentifier path, NormalizedNode data) {
            if (path.isEmpty()) {
                this.pruneAndWriteNode(path, data);
                return;
            }
            try {
                this.delegate().write(path, data);
            }
            catch (SchemaValidationFailedException e) {
                LOG.warn("Node at path : {} was pruned during write due to validation error: {}", (Object)path, (Object)e.getMessage());
                this.pruneAndWriteNode(path, data);
            }
        }

        @Override
        PruningDataTreeModification createNew(DataTreeModification delegate, DataTree dataTree, ReusableNormalizedNodePruner pruner) {
            return new Reactive(delegate, dataTree, pruner);
        }
    }

    public static final class Proactive
    extends PruningDataTreeModification {
        public Proactive(DataTreeModification delegate, DataTree dataTree, ReusableNormalizedNodePruner pruner) {
            super(delegate, dataTree, pruner);
        }

        public void merge(YangInstanceIdentifier path, NormalizedNode data) {
            this.pruneAndMergeNode(path, data);
        }

        public void write(YangInstanceIdentifier path, NormalizedNode data) {
            this.pruneAndWriteNode(path, data);
        }

        @Override
        PruningDataTreeModification createNew(DataTreeModification delegate, DataTree dataTree, ReusableNormalizedNodePruner pruner) {
            return new Proactive(delegate, dataTree, pruner);
        }
    }
}

