/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.commands.AbstractLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ClosedTransactionException;
import org.opendaylight.controller.cluster.access.commands.IncrementTransactionSequenceRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionCanCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionDoCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.RemoteProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.VotingFuture;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractProxyTransaction
implements Identifiable<TransactionIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProxyTransaction.class);
    private static final AtomicIntegerFieldUpdater<AbstractProxyTransaction> SEALED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractProxyTransaction.class, "sealed");
    private static final AtomicReferenceFieldUpdater<AbstractProxyTransaction, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractProxyTransaction.class, State.class, "state");
    private static final State OPEN = new State("OPEN");
    private static final State SEALED = new State("SEALED");
    private static final State FLUSHED = new State("FLUSHED");
    private static final State DONE = new State("DONE");
    private final Deque<Object> successfulRequests = new ArrayDeque<Object>();
    private final ProxyHistory parent;
    private long sequence;
    private volatile int sealed;
    private volatile State state;

    AbstractProxyTransaction(ProxyHistory parent, boolean isDone) {
        this.parent = Objects.requireNonNull(parent);
        if (isDone) {
            this.state = DONE;
            this.sealed = 1;
        } else {
            this.state = OPEN;
        }
    }

    final void executeInActor(Runnable command) {
        this.parent.context().executeInActor(behavior -> {
            command.run();
            return behavior;
        });
    }

    final ActorRef localActor() {
        return this.parent.localActor();
    }

    final void incrementSequence(long delta) {
        this.sequence += delta;
        LOG.debug("Transaction {} incremented sequence to {}", (Object)this, (Object)this.sequence);
    }

    final long nextSequence() {
        long ret = this.sequence++;
        LOG.debug("Transaction {} allocated sequence {}", (Object)this, (Object)ret);
        return ret;
    }

    final void delete(YangInstanceIdentifier path) {
        this.checkReadWrite();
        this.checkNotSealed();
        this.doDelete(path);
    }

    final void merge(YangInstanceIdentifier path, NormalizedNode data) {
        this.checkReadWrite();
        this.checkNotSealed();
        this.doMerge(path, data);
    }

    final void write(YangInstanceIdentifier path, NormalizedNode data) {
        this.checkReadWrite();
        this.checkNotSealed();
        this.doWrite(path, data);
    }

    final FluentFuture<Boolean> exists(YangInstanceIdentifier path) {
        this.checkNotSealed();
        return this.doExists(path);
    }

    final FluentFuture<Optional<NormalizedNode>> read(YangInstanceIdentifier path) {
        this.checkNotSealed();
        return this.doRead(path);
    }

    final void enqueueRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        LOG.debug("Transaction proxy {} enqueing request {} callback {}", new Object[]{this, request, callback});
        this.parent.enqueueRequest(request, callback, enqueuedTicks);
    }

    final void sendRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        LOG.debug("Transaction proxy {} sending request {} callback {}", new Object[]{this, request, callback});
        this.parent.sendRequest(request, callback);
    }

    final void seal() {
        boolean success = this.markSealed();
        Preconditions.checkState((boolean)success, (String)"Proxy %s was already sealed", (Object)this.getIdentifier());
        if (!this.sealAndSend(OptionalLong.empty())) {
            this.sealSuccessor();
        }
    }

    private void sealSuccessor() {
        AbstractProxyTransaction successor = this.awaitSuccessor();
        Optional<ModifyTransactionRequest> optState = this.flushState();
        if (optState.isPresent()) {
            this.forwardToSuccessor(successor, (TransactionRequest)optState.orElseThrow(), null);
        }
        successor.predecessorSealed();
    }

    private void predecessorSealed() {
        if (this.markSealed() && !this.sealAndSend(OptionalLong.empty())) {
            this.sealSuccessor();
        }
    }

    boolean sealOnly() {
        return this.sealState();
    }

    boolean sealAndSend(OptionalLong enqueuedTicks) {
        return this.sealState();
    }

    private boolean sealState() {
        this.parent.onTransactionSealed(this);
        return STATE_UPDATER.compareAndSet(this, OPEN, SEALED);
    }

    final boolean markSealed() {
        return SEALED_UPDATER.compareAndSet(this, 0, 1);
    }

    private void checkNotSealed() {
        Preconditions.checkState((this.sealed == 0 ? 1 : 0) != 0, (String)"Transaction %s has already been sealed", (Object)this.getIdentifier());
    }

    private void checkSealed() {
        Preconditions.checkState((this.sealed != 0 ? 1 : 0) != 0, (String)"Transaction %s has not been sealed yet", (Object)this.getIdentifier());
    }

    private SuccessorState getSuccessorState() {
        State local = this.state;
        Verify.verify((boolean)(local instanceof SuccessorState), (String)"State %s has unexpected class", (Object)local);
        return (SuccessorState)local;
    }

    private void checkReadWrite() {
        if (this.isSnapshotOnly()) {
            throw new UnsupportedOperationException("Transaction " + this.getIdentifier() + " is a read-only snapshot");
        }
    }

    final void recordSuccessfulRequest(@NonNull TransactionRequest<?> req) {
        this.successfulRequests.add(Verify.verifyNotNull(req));
    }

    final void recordFinishedRequest(Response<?, ?> response) {
        Object last = this.successfulRequests.peekLast();
        if (last instanceof IncrementSequence) {
            ((IncrementSequence)last).incrementDelta();
        } else {
            this.successfulRequests.addLast(new IncrementSequence(response.getSequence()));
        }
    }

    final void abort() {
        this.checkNotSealed();
        this.parent.abortTransaction(this);
        this.sendRequest(this.abortRequest(), resp -> {
            LOG.debug("Transaction {} abort completed with {}", this.getIdentifier(), resp);
            this.enqueuePurge();
        });
    }

    final void abort(VotingFuture<Empty> ret) {
        this.checkSealed();
        this.sendDoAbort(t -> {
            if (t instanceof TransactionAbortSuccess) {
                ret.voteYes();
            } else if (t instanceof RequestFailure) {
                ret.voteNo(((RequestFailure)t).getCause().unwrap());
            } else {
                ret.voteNo(AbstractProxyTransaction.unhandledResponseException(t));
            }
            LOG.debug("Transaction {} abort completed", (Object)this);
            this.enqueuePurge();
        });
    }

    final void enqueueAbort(Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        this.checkNotSealed();
        this.parent.abortTransaction(this);
        this.enqueueRequest(this.abortRequest(), resp -> {
            LOG.debug("Transaction {} abort completed with {}", this.getIdentifier(), resp);
            if (callback != null) {
                callback.accept((Response<?, ?>)resp);
            }
        }, enqueuedTicks);
    }

    final void enqueueDoAbort(Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        this.enqueueRequest((TransactionRequest<?>)new TransactionAbortRequest((TransactionIdentifier)this.getIdentifier(), this.nextSequence(), this.localActor()), callback, enqueuedTicks);
    }

    final void sendDoAbort(Consumer<Response<?, ?>> callback) {
        this.sendRequest((TransactionRequest<?>)new TransactionAbortRequest((TransactionIdentifier)this.getIdentifier(), this.nextSequence(), this.localActor()), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ListenableFuture<Boolean> directCommit() {
        this.checkReadWrite();
        this.checkSealed();
        AbstractProxyTransaction abstractProxyTransaction = this;
        synchronized (abstractProxyTransaction) {
            if (STATE_UPDATER.compareAndSet(this, SEALED, FLUSHED)) {
                SettableFuture ret = SettableFuture.create();
                this.sendRequest((TransactionRequest)Verify.verifyNotNull(this.commitRequest(false)), t -> {
                    if (t instanceof TransactionCommitSuccess) {
                        ret.set((Object)Boolean.TRUE);
                    } else if (t instanceof RequestFailure) {
                        Throwable cause = ((RequestFailure)t).getCause().unwrap();
                        if (cause instanceof ClosedTransactionException) {
                            ret.set((Object)Boolean.TRUE);
                        } else {
                            ret.setException(cause);
                        }
                    } else {
                        ret.setException((Throwable)AbstractProxyTransaction.unhandledResponseException(t));
                    }
                    LOG.debug("Transaction {} directCommit completed", (Object)this);
                    this.enqueuePurge();
                });
                return ret;
            }
        }
        return this.awaitSuccessor().directCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void canCommit(VotingFuture<?> ret) {
        this.checkReadWrite();
        this.checkSealed();
        AbstractProxyTransaction abstractProxyTransaction = this;
        synchronized (abstractProxyTransaction) {
            if (STATE_UPDATER.compareAndSet(this, SEALED, FLUSHED)) {
                TransactionRequest req = (TransactionRequest)Verify.verifyNotNull(this.commitRequest(true));
                this.sendRequest(req, t -> {
                    if (t instanceof TransactionCanCommitSuccess) {
                        ret.voteYes();
                    } else if (t instanceof RequestFailure) {
                        ret.voteNo(((RequestFailure)t).getCause().unwrap());
                    } else {
                        ret.voteNo(AbstractProxyTransaction.unhandledResponseException(t));
                    }
                    this.recordSuccessfulRequest(req);
                    LOG.debug("Transaction {} canCommit completed", (Object)this);
                });
                return;
            }
        }
        this.awaitSuccessor().canCommit(ret);
    }

    private AbstractProxyTransaction awaitSuccessor() {
        return this.getSuccessorState().await();
    }

    final void preCommit(VotingFuture<?> ret) {
        this.checkReadWrite();
        this.checkSealed();
        TransactionPreCommitRequest req = new TransactionPreCommitRequest((TransactionIdentifier)this.getIdentifier(), this.nextSequence(), this.localActor());
        this.sendRequest((TransactionRequest<?>)req, arg_0 -> this.lambda$preCommit$6(ret, (TransactionRequest)req, arg_0));
    }

    private void onPreCommitComplete(TransactionRequest<?> req) {
        LOG.debug("Transaction {} preCommit completed, clearing successfulRequests", (Object)this);
        this.successfulRequests.clear();
        this.recordSuccessfulRequest(req);
    }

    final void doCommit(VotingFuture<?> ret) {
        this.checkReadWrite();
        this.checkSealed();
        this.sendRequest((TransactionRequest<?>)new TransactionDoCommitRequest((TransactionIdentifier)this.getIdentifier(), this.nextSequence(), this.localActor()), t -> {
            if (t instanceof TransactionCommitSuccess) {
                ret.voteYes();
            } else if (t instanceof RequestFailure) {
                ret.voteNo(((RequestFailure)t).getCause().unwrap());
            } else {
                ret.voteNo(AbstractProxyTransaction.unhandledResponseException(t));
            }
            LOG.debug("Transaction {} doCommit completed", (Object)this);
            this.parent.completeTransaction(this);
            this.enqueuePurge();
        });
    }

    private void enqueuePurge() {
        this.enqueuePurge(null);
    }

    final void enqueuePurge(Consumer<Response<?, ?>> callback) {
        this.enqueuePurge(callback, this.parent.currentTime());
    }

    final void enqueuePurge(Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        LOG.debug("{}: initiating purge", (Object)this);
        State prev = this.state;
        if (prev instanceof SuccessorState) {
            ((SuccessorState)prev).setDone();
        } else {
            boolean success = STATE_UPDATER.compareAndSet(this, prev, DONE);
            if (!success) {
                LOG.warn("{}: moved from state {} while we were purging it", (Object)this, (Object)prev);
            }
        }
        this.successfulRequests.clear();
        this.enqueueRequest((TransactionRequest<?>)new TransactionPurgeRequest((TransactionIdentifier)this.getIdentifier(), this.nextSequence(), this.localActor()), resp -> {
            LOG.debug("{}: purge completed", (Object)this);
            this.parent.purgeTransaction(this);
            if (callback != null) {
                callback.accept((Response<?, ?>)resp);
            }
        }, enqueuedTicks);
    }

    final synchronized void startReconnect() {
        SuccessorState nextState = new SuccessorState();
        State prevState = STATE_UPDATER.getAndSet(this, nextState);
        LOG.debug("Start reconnect of proxy {} previous state {}", (Object)this, (Object)prevState);
        Verify.verify((!(prevState instanceof SuccessorState) ? 1 : 0) != 0, (String)"Proxy %s duplicate reconnect attempt after %s", (Object)this, (Object)prevState);
        nextState.setPrevState(prevState);
    }

    final void replayMessages(ProxyHistory successorHistory, Iterable<ConnectionEntry> enqueuedEntries) {
        SuccessorState local = this.getSuccessorState();
        State prevState = local.getPrevState();
        AbstractProxyTransaction successor = successorHistory.createTransactionProxy((TransactionIdentifier)this.getIdentifier(), this.isSnapshotOnly(), local.isDone());
        LOG.debug("{} created successor {}", (Object)this, (Object)successor);
        local.setSuccessor(successor);
        if (!this.successfulRequests.isEmpty()) {
            ConnectionEntry firstInQueue = (ConnectionEntry)Iterables.getFirst(enqueuedEntries, null);
            long now = firstInQueue != null ? firstInQueue.getEnqueuedTicks() : this.parent.currentTime();
            for (Object obj : this.successfulRequests) {
                if (obj instanceof TransactionRequest) {
                    LOG.debug("Forwarding successful request {} to successor {}", obj, (Object)successor);
                    successor.doReplayRequest((TransactionRequest)obj, resp -> {}, now);
                    continue;
                }
                Verify.verify((boolean)(obj instanceof IncrementSequence));
                IncrementSequence increment = (IncrementSequence)obj;
                successor.doReplayRequest((TransactionRequest<?>)new IncrementTransactionSequenceRequest((TransactionIdentifier)this.getIdentifier(), increment.getSequence(), this.localActor(), this.isSnapshotOnly(), increment.getDelta()), resp -> {}, now);
                LOG.debug("Incrementing sequence {} to successor {}", obj, (Object)successor);
            }
            LOG.debug("{} replayed {} successful requests", this.getIdentifier(), (Object)this.successfulRequests.size());
            this.successfulRequests.clear();
        }
        Iterator<ConnectionEntry> it = enqueuedEntries.iterator();
        while (it.hasNext()) {
            ConnectionEntry e = it.next();
            Request req = e.getRequest();
            if (!((TransactionIdentifier)this.getIdentifier()).equals((Object)req.getTarget())) continue;
            Verify.verify((boolean)(req instanceof TransactionRequest), (String)"Unhandled request %s", (Object)req);
            LOG.debug("Replaying queued request {} to successor {}", (Object)req, (Object)successor);
            successor.doReplayRequest((TransactionRequest)req, e.getCallback(), e.getEnqueuedTicks());
            it.remove();
        }
        if (SEALED.equals(prevState)) {
            LOG.debug("Proxy {} reconnected while being sealed, propagating state to successor {}", (Object)this, (Object)successor);
            long enqueuedTicks = this.parent.currentTime();
            Optional<ModifyTransactionRequest> optState = this.flushState();
            if (optState.isPresent()) {
                successor.handleReplayedRemoteRequest((TransactionRequest)optState.orElseThrow(), null, enqueuedTicks);
            }
            if (successor.markSealed()) {
                successor.sealAndSend(OptionalLong.of(enqueuedTicks));
            }
        }
    }

    private void doReplayRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        if (request instanceof AbstractLocalTransactionRequest) {
            this.handleReplayedLocalRequest((AbstractLocalTransactionRequest)request, callback, enqueuedTicks);
        } else {
            this.handleReplayedRemoteRequest(request, callback, enqueuedTicks);
        }
    }

    final void finishReconnect() {
        SuccessorState local = this.getSuccessorState();
        LOG.debug("Finishing reconnect of proxy {}", (Object)this);
        local.finish();
    }

    final void forwardRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        this.forwardToSuccessor(this.getSuccessorState().getSuccessor(), request, callback);
    }

    final void forwardToSuccessor(AbstractProxyTransaction successor, TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        if (successor instanceof LocalProxyTransaction) {
            this.forwardToLocal((LocalProxyTransaction)successor, request, callback);
        } else if (successor instanceof RemoteProxyTransaction) {
            this.forwardToRemote((RemoteProxyTransaction)successor, request, callback);
        } else {
            throw new IllegalStateException("Unhandled successor " + successor);
        }
    }

    final void replayRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        this.getSuccessorState().getSuccessor().doReplayRequest(request, callback, enqueuedTicks);
    }

    abstract boolean isSnapshotOnly();

    abstract void doDelete(YangInstanceIdentifier var1);

    abstract void doMerge(YangInstanceIdentifier var1, NormalizedNode var2);

    abstract void doWrite(YangInstanceIdentifier var1, NormalizedNode var2);

    abstract FluentFuture<Boolean> doExists(YangInstanceIdentifier var1);

    abstract FluentFuture<Optional<NormalizedNode>> doRead(YangInstanceIdentifier var1);

    abstract @GuardedBy(value={"this"}) Optional<ModifyTransactionRequest> flushState();

    abstract TransactionRequest<?> abortRequest();

    abstract TransactionRequest<?> commitRequest(boolean var1);

    abstract void forwardToRemote(RemoteProxyTransaction var1, TransactionRequest<?> var2, Consumer<Response<?, ?>> var3);

    abstract void forwardToLocal(LocalProxyTransaction var1, TransactionRequest<?> var2, Consumer<Response<?, ?>> var3);

    abstract void handleReplayedLocalRequest(AbstractLocalTransactionRequest<?> var1, @Nullable Consumer<Response<?, ?>> var2, long var3);

    abstract void handleReplayedRemoteRequest(TransactionRequest<?> var1, @Nullable Consumer<Response<?, ?>> var2, long var3);

    static final @NonNull IllegalArgumentException unhandledRequest(TransactionRequest<?> request) {
        return new IllegalArgumentException("Unhandled request " + request);
    }

    private static @NonNull IllegalStateException unhandledResponseException(Response<?, ?> resp) {
        return new IllegalStateException("Unhandled response " + resp.getClass());
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identifier", this.getIdentifier()).add("state", (Object)this.state).toString();
    }

    private /* synthetic */ void lambda$preCommit$6(VotingFuture ret, TransactionRequest req, Response t) {
        if (t instanceof TransactionPreCommitSuccess) {
            ret.voteYes();
        } else if (t instanceof RequestFailure) {
            ret.voteNo(((RequestFailure)t).getCause().unwrap());
        } else {
            ret.voteNo(AbstractProxyTransaction.unhandledResponseException(t));
        }
        this.onPreCommitComplete(req);
    }

    private static class State {
        private final String string;

        State(String string) {
            this.string = Objects.requireNonNull(string);
        }

        public final String toString() {
            return this.string;
        }
    }

    private static class SuccessorState
    extends State {
        private final CountDownLatch latch = new CountDownLatch(1);
        private AbstractProxyTransaction successor;
        private State prevState;
        private boolean done;

        SuccessorState() {
            super("SUCCESSOR");
        }

        AbstractProxyTransaction await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for latch of {}", (Object)this.successor);
                throw new IllegalStateException(e);
            }
            return this.successor;
        }

        void finish() {
            this.latch.countDown();
        }

        State getPrevState() {
            return (State)Verify.verifyNotNull((Object)this.prevState, (String)"Attempted to access previous state, which was not set", (Object[])new Object[0]);
        }

        void setPrevState(State prevState) {
            Verify.verify((this.prevState == null ? 1 : 0) != 0, (String)"Attempted to set previous state to %s when we already have %s", (Object)prevState, (Object)this.prevState);
            this.prevState = Objects.requireNonNull(prevState);
            this.done = DONE.equals(prevState);
        }

        AbstractProxyTransaction getSuccessor() {
            return (AbstractProxyTransaction)Verify.verifyNotNull((Object)this.successor);
        }

        void setSuccessor(AbstractProxyTransaction successor) {
            Verify.verify((this.successor == null ? 1 : 0) != 0, (String)"Attempted to set successor to %s when we already have %s", (Object)successor, (Object)this.successor);
            this.successor = Objects.requireNonNull(successor);
        }

        boolean isDone() {
            return this.done;
        }

        void setDone() {
            this.done = true;
        }
    }

    private static final class IncrementSequence {
        private final long sequence;
        private long delta = 0L;

        IncrementSequence(long sequence) {
            this.sequence = sequence;
        }

        long getDelta() {
            return this.delta;
        }

        long getSequence() {
            return this.sequence;
        }

        void incrementDelta() {
            ++this.delta;
        }
    }
}

