/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionParent;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;

abstract class AbstractShardDataTreeTransaction<T extends DataTreeSnapshot>
implements Identifiable<TransactionIdentifier> {
    private final ShardDataTreeTransactionParent parent;
    private final TransactionIdentifier id;
    private final T snapshot;
    private boolean closed;

    AbstractShardDataTreeTransaction(ShardDataTreeTransactionParent parent, TransactionIdentifier id, T snapshot) {
        this.parent = Objects.requireNonNull(parent);
        this.snapshot = (DataTreeSnapshot)Objects.requireNonNull(snapshot);
        this.id = Objects.requireNonNull(id);
    }

    public final TransactionIdentifier getIdentifier() {
        return this.id;
    }

    final ShardDataTreeTransactionParent getParent() {
        return this.parent;
    }

    final T getSnapshot() {
        return this.snapshot;
    }

    final boolean isClosed() {
        return this.closed;
    }

    protected final boolean close() {
        if (this.closed) {
            return false;
        }
        this.closed = true;
        return true;
    }

    final void abort(Runnable callback) {
        Preconditions.checkState((boolean)this.close(), (Object)"Transaction is already closed");
        this.parent.abortTransaction(this, callback);
    }

    final void abortFromTransactionActor() {
        if (this.close()) {
            this.parent.abortFromTransactionActor(this);
        }
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("closed", this.closed).add("snapshot", this.snapshot).toString();
    }
}

