/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.Props;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opendaylight.controller.cluster.datastore.DefaultShardDataTreeChangeListenerPublisher;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeNotificationPublisherActor;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

public final class ShardDataTreeChangePublisherActor
extends ShardDataTreeNotificationPublisherActor<DefaultShardDataTreeChangeListenerPublisher> {
    private ShardDataTreeChangePublisherActor(String name, String logContext) {
        super(new DefaultShardDataTreeChangeListenerPublisher(logContext), name, logContext);
    }

    @Override
    protected void handleReceive(Object message) {
        if (message instanceof RegisterListener) {
            RegisterListener reg = (RegisterListener)message;
            this.LOG.debug("{}: Received {}", (Object)this.logContext(), (Object)reg);
            if (reg.initialState.isPresent()) {
                DefaultShardDataTreeChangeListenerPublisher.notifySingleListener(reg.path, reg.listener, reg.initialState.orElseThrow(), this.logContext());
            } else {
                reg.listener.onInitialData();
            }
            ((DefaultShardDataTreeChangeListenerPublisher)this.publisher()).registerTreeChangeListener(reg.path, reg.listener, reg.onRegistration);
        } else {
            super.handleReceive(message);
        }
    }

    static Props props(String name, String logContext) {
        return Props.create(ShardDataTreeChangePublisherActor.class, (Object[])new Object[]{name, logContext});
    }

    static class RegisterListener {
        private final YangInstanceIdentifier path;
        private final DOMDataTreeChangeListener listener;
        private final Optional<DataTreeCandidate> initialState;
        private final Consumer<Registration> onRegistration;

        RegisterListener(YangInstanceIdentifier path, DOMDataTreeChangeListener listener, Optional<DataTreeCandidate> initialState, Consumer<Registration> onRegistration) {
            this.path = Objects.requireNonNull(path);
            this.listener = Objects.requireNonNull(listener);
            this.initialState = Objects.requireNonNull(initialState);
            this.onRegistration = Objects.requireNonNull(onRegistration);
        }

        public String toString() {
            return "RegisterListener [path=" + this.path + ", listener=" + this.listener + ", initialState present=" + this.initialState.isPresent() + "]";
        }
    }
}

