/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractVersionedShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.MS;
import org.opendaylight.controller.cluster.datastore.persisted.PayloadVersion;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshotMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Beta
public final class MetadataShardDataTreeSnapshot
extends AbstractVersionedShardDataTreeSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This field is not Serializable but this class implements writeReplace to delegate serialization to a Proxy class and thus instances of this class aren't serialized. FindBugs does not recognize this.")
    private final Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>> metadata;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="See above justification.")
    private final NormalizedNode rootNode;

    public MetadataShardDataTreeSnapshot(NormalizedNode rootNode) {
        this(rootNode, (Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>>)ImmutableMap.of());
    }

    public MetadataShardDataTreeSnapshot(NormalizedNode rootNode, Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>> metadata) {
        this.rootNode = Objects.requireNonNull(rootNode);
        this.metadata = ImmutableMap.copyOf(metadata);
    }

    public Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>> getMetadata() {
        return this.metadata;
    }

    @Override
    NormalizedNode rootNode() {
        return this.rootNode;
    }

    @Override
    PayloadVersion version() {
        return PayloadVersion.POTASSIUM;
    }

    private Object writeReplace() {
        return new MS(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("metadata", this.metadata).toString();
    }
}

