/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.akka.impl;

import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Terminated;
import akka.dispatch.OnComplete;
import com.typesafe.config.Config;
import java.util.EventListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.ActorSystemProviderListener;
import org.opendaylight.controller.cluster.datastore.TerminationMonitor;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Await;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ActorSystemProviderImpl
implements ActorSystemProvider,
AutoCloseable {
    private static final String ACTOR_SYSTEM_NAME = "opendaylight-cluster-data";
    private static final Logger LOG = LoggerFactory.getLogger(ActorSystemProviderImpl.class);
    private final @NonNull ActorSystem actorSystem;
    private final ListenerRegistry<ActorSystemProviderListener> listeners = ListenerRegistry.create();

    public ActorSystemProviderImpl(ClassLoader classLoader, Props quarantinedMonitorActorProps, Config akkaConfig) {
        LOG.info("Creating new ActorSystem");
        this.actorSystem = ActorSystem.create((String)ACTOR_SYSTEM_NAME, (Config)akkaConfig, (ClassLoader)classLoader);
        this.actorSystem.actorOf(Props.create(TerminationMonitor.class, (Object[])new Object[0]), "termination-monitor");
        this.actorSystem.actorOf(quarantinedMonitorActorProps, "quarantined-monitor");
    }

    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    public ListenerRegistration<ActorSystemProviderListener> registerActorSystemProviderListener(ActorSystemProviderListener listener) {
        return this.listeners.register((EventListener)listener);
    }

    public Future<Terminated> asyncClose() {
        LOG.info("Shutting down ActorSystem");
        Future ret = this.actorSystem.terminate();
        ret.onComplete((Function1)new OnComplete<Terminated>(){

            public void onComplete(Throwable failure, Terminated success) throws Throwable {
                if (failure != null) {
                    LOG.warn("ActorSystem failed to shut down", failure);
                } else {
                    LOG.info("ActorSystem shut down");
                }
            }
        }, (ExecutionContext)ExecutionContext.global());
        return ret;
    }

    public void close(FiniteDuration wait) throws TimeoutException, InterruptedException {
        Await.result(this.asyncClose(), (Duration)wait);
    }

    @Override
    public void close() throws TimeoutException, InterruptedException {
        this.close(FiniteDuration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
    }
}

