/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev231229;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class NonZeroUint32Type
implements ScalarTypeObject<Uint32>,
Serializable {
    private static final long serialVersionUID = -7519597503656647670L;
    private final Uint32 _value;

    private static void check_valueRange(long value) {
        if (value >= 1L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..4294967295]]", (long)value);
    }

    @ConstructorParameters(value={"value"})
    public NonZeroUint32Type(Uint32 _value) {
        if (_value != null) {
            NonZeroUint32Type.check_valueRange(_value.longValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public NonZeroUint32Type(NonZeroUint32Type source) {
        this._value = source._value;
    }

    public static NonZeroUint32Type getDefaultInstance(String defaultValue) {
        return new NonZeroUint32Type(Uint32.valueOf((String)defaultValue));
    }

    public Uint32 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof NonZeroUint32Type)) return false;
        NonZeroUint32Type other = (NonZeroUint32Type)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(NonZeroUint32Type.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

