package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>entity-owners</b>
 * <pre>
 * container entity-owners {
 *   list entity-type {
 *     key type;
 *     leaf type {
 *       type string;
 *     }
 *     list entity {
 *       key id;
 *       leaf id {
 *         type instance-identifier;
 *       }
 *       leaf owner {
 *         type string;
 *       }
 *       list candidate {
 *         key name;
 *         ordered-by user;
 *         leaf name {
 *           type string;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>entity-owners/entity-owners</i>
 *
 * <p>To create instances of this class use {@link EntityOwnersBuilder}.
 * @see EntityOwnersBuilder
 *
 */
public interface EntityOwners
    extends
    ChildOf<EntityOwnersData>,
    Augmentable<EntityOwners>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("entity-owners");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.EntityOwners> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.EntityOwners.class;
    }
    
    /**
     * @return <code>java.util.List</code> <code>entityType</code>, or <code>null</code> if not present
     */
    @Nullable List<EntityType> getEntityType();
    
    /**
     * @return <code>java.util.List</code> <code>entityType</code>, or an empty list if it is not present
     */
    default @NonNull List<EntityType> nonnullEntityType() {
        return CodeHelpers.nonnull(getEntityType());
    }

}

