package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the base YANG definitions for an implementation of the 
 * EntityOwnershipService which stores entity ownership information in the data 
 * store
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>entity-owners</b>
 * <pre>
 * module entity-owners {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:controller:md:sal:clustering:entity-owners;
 *   prefix entity-owners;
 *   revision 2015-08-04 {
 *   }
 *   container entity-owners {
 *     list entity-type {
 *       key type;
 *       leaf type {
 *         type string;
 *       }
 *       list entity {
 *         key id;
 *         leaf id {
 *           type instance-identifier;
 *         }
 *         leaf owner {
 *           type string;
 *         }
 *         list candidate {
 *           key name;
 *           ordered-by user;
 *           leaf name {
 *             type string;
 *           }
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface EntityOwnersData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.EntityOwners</code> <code>entityOwners</code>, or <code>null</code> if not present
     */
    @Nullable EntityOwners getEntityOwners();

}

