package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class EntityTypeKey
 implements Identifier<EntityType> {
    private static final long serialVersionUID = 510464943519768216L;
    private final String _type;


    public EntityTypeKey(String _type) {
    
        this._type = _type;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public EntityTypeKey(EntityTypeKey source) {
        this._type = source._type;
    }


    public String getType() {
        return _type;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_type);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityTypeKey)) {
            return false;
        }
        final EntityTypeKey other = (EntityTypeKey) obj;
        if (!Objects.equals(_type, other._type)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(EntityTypeKey.class);
        CodeHelpers.appendValue(helper, "_type", _type);
        return helper.toString();
    }
}

