package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.entity.Candidate;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>entity-owners</b>
 * <pre>
 * list entity {
 *   key id;
 *   leaf id {
 *     type instance-identifier;
 *   }
 *   leaf owner {
 *     type string;
 *   }
 *   list candidate {
 *     key name;
 *     ordered-by user;
 *     leaf name {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>entity-owners/entity-owners/entity-type/entity</i>
 *
 * <p>To create instances of this class use {@link EntityBuilder}.
 * @see EntityBuilder
 * @see EntityKey
 *
 */
public interface Entity
    extends
    ChildOf<EntityType>,
    Augmentable<Entity>,
    Identifiable<EntityKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("entity");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity.class;
    }
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.binding.InstanceIdentifier</code> <code>id</code>, or <code>null</code> if not present
     */
    @Nullable InstanceIdentifier<?> getId();
    
    /**
     * @return <code>java.lang.String</code> <code>owner</code>, or <code>null</code> if not present
     */
    @Nullable String getOwner();
    
    /**
     * @return <code>java.util.List</code> <code>candidate</code>, or <code>null</code> if not present
     */
    @Nullable List<Candidate> getCandidate();
    
    /**
     * @return <code>java.util.List</code> <code>candidate</code>, or an empty list if it is not present
     */
    default @NonNull List<Candidate> nonnullCandidate() {
        return CodeHelpers.nonnull(getCandidate());
    }
    
    @Override
    EntityKey key();

}

