/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.entityownership;

import com.google.common.annotations.Beta;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.entityownership.DistributedEntityOwnershipService;
import org.opendaylight.controller.cluster.entityownership.selectionstrategy.EntityOwnerSelectionStrategyConfigReader;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipState;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipCandidateRegistration;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListenerRegistration;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true, configurationPid={"org.opendaylight.controller.cluster.entity.owner.selection.strategies"}, property={"type=default"})
public final class OSGiDistributedEntityOwnershipService
implements DOMEntityOwnershipService {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiDistributedEntityOwnershipService.class);
    @Reference(target="(type=distributed-operational)")
    DistributedDataStoreInterface operDatastore = null;
    private DistributedEntityOwnershipService delegate;

    public DOMEntityOwnershipCandidateRegistration registerCandidate(DOMEntity entity) throws CandidateAlreadyRegisteredException {
        return this.delegate.registerCandidate(entity);
    }

    public DOMEntityOwnershipListenerRegistration registerListener(String entityType, DOMEntityOwnershipListener listener) {
        return this.delegate.registerListener(entityType, listener);
    }

    public Optional<EntityOwnershipState> getOwnershipState(DOMEntity forEntity) {
        return this.delegate.getOwnershipState(forEntity);
    }

    public boolean isCandidateRegistered(DOMEntity forEntity) {
        return this.delegate.isCandidateRegistered(forEntity);
    }

    @Activate
    void activate(Map<Object, Object> properties) {
        LOG.info("Distributed Entity Ownership Service starting");
        this.delegate = DistributedEntityOwnershipService.start(this.operDatastore.getActorUtils(), EntityOwnerSelectionStrategyConfigReader.loadStrategyWithConfig(properties));
        LOG.info("Distributed Entity Ownership Service started");
    }

    @Deactivate
    void deactivate() {
        LOG.info("Distributed Entity Ownership Service stopping");
        this.delegate.close();
        LOG.info("Distributed Entity Ownership Service stopped");
    }
}

