/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.entityownership.selectionstrategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.cluster.entityownership.selectionstrategy.AbstractEntityOwnerSelectionStrategy;

public class LeastLoadedCandidateSelectionStrategy
extends AbstractEntityOwnerSelectionStrategy {
    private final Map<String, Long> localStatistics = new HashMap<String, Long>();

    protected LeastLoadedCandidateSelectionStrategy(long selectionDelayInMillis, Map<String, Long> initialStatistics) {
        super(selectionDelayInMillis, initialStatistics);
        this.localStatistics.putAll(initialStatistics);
    }

    @Override
    public String newOwner(String currentOwner, Collection<String> viableCandidates) {
        Preconditions.checkArgument((viableCandidates.size() > 0 ? 1 : 0) != 0);
        String leastLoadedCandidate = null;
        long leastLoadedCount = Long.MAX_VALUE;
        if (!Strings.isNullOrEmpty((String)currentOwner)) {
            long localVal = (Long)MoreObjects.firstNonNull((Object)this.localStatistics.get(currentOwner), (Object)0L);
            this.localStatistics.put(currentOwner, localVal - 1L);
        }
        for (String candidateName : viableCandidates) {
            long val = (Long)MoreObjects.firstNonNull((Object)this.localStatistics.get(candidateName), (Object)0L);
            if (val >= leastLoadedCount) continue;
            leastLoadedCount = val;
            leastLoadedCandidate = candidateName;
        }
        if (leastLoadedCandidate == null) {
            leastLoadedCandidate = viableCandidates.iterator().next();
        }
        this.localStatistics.put(leastLoadedCandidate, leastLoadedCount + 1L);
        return leastLoadedCandidate;
    }

    @VisibleForTesting
    Map<String, Long> getLocalStatistics() {
        return this.localStatistics;
    }
}

