package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL} instances.
 *
 * @see org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL
 *
 */
public class XSQLBuilder implements Builder <org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL> {

    private java.lang.String _port;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>>, Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>> augmentation = Collections.emptyMap();

    public XSQLBuilder() {
    }

    public XSQLBuilder(XSQL base) {
        this._port = base.getPort();
        if (base instanceof XSQLImpl) {
            XSQLImpl impl = (XSQLImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.String getPort() {
        return _port;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public XSQLBuilder setPort(final java.lang.String value) {
        this._port = value;
        return this;
    }
    
    public XSQLBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public XSQLBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public XSQL build() {
        return new XSQLImpl(this);
    }

    private static final class XSQLImpl implements XSQL {

        public java.lang.Class<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL.class;
        }

        private final java.lang.String _port;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>>, Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>> augmentation = Collections.emptyMap();

        private XSQLImpl(XSQLBuilder base) {
            this._port = base.getPort();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>>, Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>>, Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.String getPort() {
            return _port;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_port);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL other = (org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL)obj;
            if (!Objects.equals(_port, other.getPort())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                XSQLImpl otherImpl = (XSQLImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>>, Augmentation<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQL>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("XSQL [");
            boolean first = true;
        
            if (_port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(_port);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
