package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.Configuration;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration.xsql.AsyncDataBroker;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration.xsql.SchemaService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration.xsql.DataBroker;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>XSQL</b>
 * <pre>
 * case XSQL {
 *     container data-broker {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (http://netconfcentral.org/ns/XSQL?revision=2014-06-26)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container async-data-broker {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (http://netconfcentral.org/ns/XSQL?revision=2014-06-26)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container schema-service {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (http://netconfcentral.org/ns/XSQL?revision=2014-06-26)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>XSQL/modules/module/configuration/(http://netconfcentral.org/ns/XSQL?revision=2014-06-26)XSQL</i>
 *
 */
public interface XSQL
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration.XSQL>,
    Configuration
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("http://netconfcentral.org/ns/XSQL",
        "2014-06-26", "XSQL").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration.xsql.DataBroker</code> <code>dataBroker</code>, or <code>null</code> if not present
     */
    DataBroker getDataBroker();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration.xsql.AsyncDataBroker</code> <code>asyncDataBroker</code>, or <code>null</code> if not present
     */
    AsyncDataBroker getAsyncDataBroker();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration.xsql.SchemaService</code> <code>schemaService</code>, or <code>null</code> if not present
     */
    SchemaService getSchemaService();

}

