/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.xsql;

import com.google.common.base.Optional;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLBluePrint;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLBluePrintNode;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLBluePrintRelation;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLColumn;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLODLUtils;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLThreadPool;
import org.opendaylight.controller.md.sal.dom.xsql.jdbc.JDBCResultSet;
import org.opendaylight.controller.md.sal.dom.xsql.jdbc.JDBCServer;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class XSQLAdapter
extends Thread
implements SchemaContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(XSQLAdapter.class);
    private static final int SLEEP = 10000;
    private static XSQLAdapter a = new XSQLAdapter();
    private static PrintStream l = null;
    private static String tmpDir = null;
    private static File xqlLog = null;
    public boolean stopped = false;
    private String username;
    private String password;
    private final String transport = "tcp";
    private int reconnectTimeout;
    private int nThreads;
    private int qsize;
    private final String applicationName = "NQL Adapter";
    private StringBuffer lastInputString = new StringBuffer();
    private boolean toCsv = false;
    private String exportToFileName = null;
    private final XSQLThreadPool threadPool = new XSQLThreadPool(1, "Tasks", 2000);
    private final JDBCServer jdbcServer = new JDBCServer(this);
    private String pinningFile;
    private ServerSocket serverSocket = null;
    private DOMDataBroker domDataBroker = null;
    @GuardedBy(value="this")
    private SchemaContext context;
    @GuardedBy(value="this")
    private XSQLBluePrint bluePrint = new XSQLBluePrint();

    private XSQLAdapter() {
        XSQLAdapter.log("Starting Adapter");
        this.setDaemon(true);
        try {
            this.serverSocket = new ServerSocket(34343);
        }
        catch (Exception err) {
            XSQLAdapter.log(err);
        }
        this.start();
        XSQLAdapter.log("Adapter Started!");
    }

    public synchronized void loadBluePrint() {
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("BluePrintCache.dat");
            if (in != null) {
                this.bluePrint = XSQLBluePrint.load(in);
                in.close();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public static XSQLAdapter getInstance() {
        return a;
    }

    public static File getXQLLogfile() {
        tmpDir = System.getProperty("java.io.tmpdir");
        xqlLog = new File(tmpDir + "/xql.log");
        return xqlLog;
    }

    public static void main(String[] args) {
        XSQLAdapter adapter = new XSQLAdapter();
        adapter.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void log(String str) {
        try {
            if (l == null) {
                Class<XSQLAdapter> clazz = XSQLAdapter.class;
                // MONITORENTER : org.opendaylight.controller.md.sal.dom.xsql.XSQLAdapter.class
                if (l == null) {
                    l = new PrintStream(new FileOutputStream(XSQLAdapter.getXQLLogfile()));
                }
                // MONITOREXIT : clazz
            }
            l.print(new Date());
            l.print(" - ");
            l.println(str);
            return;
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void log(Exception e) {
        try {
            if (l == null) {
                Class<XSQLAdapter> clazz = XSQLAdapter.class;
                // MONITORENTER : org.opendaylight.controller.md.sal.dom.xsql.XSQLAdapter.class
                if (l == null) {
                    l = new PrintStream(new FileOutputStream(XSQLAdapter.getXQLLogfile()));
                }
                // MONITOREXIT : clazz
            }
            l.print(new Date());
            l.print(" - ");
            e.printStackTrace(l);
            return;
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public synchronized void onGlobalContextUpdated(SchemaContext context) {
        this.bluePrint = null;
        this.context = context;
    }

    public void setDataBroker(DOMDataBroker ddb) {
        this.domDataBroker = ddb;
    }

    public synchronized XSQLBluePrint getBluePrint() {
        if (this.bluePrint == null) {
            LOG.warn("XSQL is not supported in production environments and will be removed in a future release");
            this.bluePrint = XSQLBluePrint.create(this.context);
        }
        return this.bluePrint;
    }

    public List<NormalizedNode<?, ?>> collectModuleRoots(XSQLBluePrintNode table, LogicalDatastoreType type) {
        if (table.getParent().isModule()) {
            try {
                LinkedList result = new LinkedList();
                YangInstanceIdentifier instanceIdentifier = YangInstanceIdentifier.builder().node(XSQLODLUtils.getPath(table.getFirstFromSchemaNodes()).get(0)).build();
                DOMDataReadOnlyTransaction t = this.domDataBroker.newReadOnlyTransaction();
                Optional node = (Optional)t.read(type, instanceIdentifier).get();
                t.close();
                if (node.isPresent()) {
                    result.add((NormalizedNode<?, ?>)node.get());
                }
                return result;
            }
            catch (Exception err) {
                XSQLAdapter.log(err);
            }
        } else {
            return this.collectModuleRoots(table.getParent(), type);
        }
        return null;
    }

    public void execute(JDBCResultSet rs) {
        if (this.domDataBroker == null) {
            rs.setFinished(true);
            return;
        }
        List<XSQLBluePrintNode> tables = rs.getTables();
        List<NormalizedNode<?, ?>> roots = this.collectModuleRoots(tables.get(0), LogicalDatastoreType.OPERATIONAL);
        roots.addAll(this.collectModuleRoots(tables.get(0), LogicalDatastoreType.CONFIGURATION));
        if (roots.isEmpty()) {
            rs.setFinished(true);
        }
        XSQLBluePrintNode main = rs.getMainTable();
        LinkedList<NETask> tasks = new LinkedList<NETask>();
        for (NormalizedNode<?, ?> entry : roots) {
            NETask task = new NETask(rs, entry, main, this.getBluePrint());
            ++rs.numberOfTasks;
            tasks.add(task);
        }
        for (NETask task : tasks) {
            this.threadPool.addTask(task);
        }
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                Socket s = this.serverSocket.accept();
                new TelnetConnection(s);
            }
            catch (Exception err) {
                err.printStackTrace();
                try {
                    Thread.sleep(20000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.stopped = true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processCommand(StringBuffer inputString, PrintStream sout) {
        if (inputString.toString().trim().equals("r")) {
            sout.println(this.lastInputString);
            inputString = this.lastInputString;
        }
        this.lastInputString = inputString;
        String input = inputString.toString().trim();
        if (input.startsWith("setExcel")) {
            String substr = input.substring("setExcel".length()).trim();
            if (substr.equals("")) {
                // empty if block
            }
        } else if (input.startsWith("list vrel")) {
            String substr = input.substring("list vrel".length()).trim();
            XSQLBluePrintNode node = this.getBluePrint().getBluePrintNodeByTableName(substr);
            if (node == null) {
                sout.println("Unknown Interface " + substr);
                return;
            }
            ArrayList<String> fld = new ArrayList<String>();
            for (XSQLBluePrintRelation xSQLBluePrintRelation : node.getRelations()) {
                fld.add(xSQLBluePrintRelation.toString());
            }
            Object[] p = fld.toArray(new String[fld.size()]);
            Arrays.sort(p);
            for (Object element : p) {
                sout.println((String)element);
            }
        } else if (input.startsWith("list vfields")) {
            String substr = input.substring("list vfields".length()).trim();
            XSQLBluePrintNode node = this.getBluePrint().getBluePrintNodeByTableName(substr);
            if (node == null) {
                sout.println("Unknown Interface " + substr);
                return;
            }
            ArrayList<String> fld = new ArrayList<String>();
            for (XSQLColumn xSQLColumn : node.getColumns()) {
                fld.add(xSQLColumn.getName());
            }
            Object[] p = fld.toArray(new String[fld.size()]);
            Arrays.sort(p);
            for (Object element : p) {
                sout.println((String)element);
            }
        } else if (input.startsWith("jdbc")) {
            String addr = input.substring(5).trim();
            this.jdbcServer.connectToClient(addr);
            sout.println("Connected To " + addr);
        } else if (!input.startsWith("fetch")) {
            if (input.startsWith("list vtables")) {
                Object[] iNames = this.getBluePrint().getAllTableNames().toArray(new String[0]);
                Arrays.sort(iNames);
                sout.println();
                for (Object object : iNames) {
                    sout.println((String)object);
                }
            } else if (!(input.equals("help") || input.equals("?") || input.equals("avmdata") || input.equals("innerjoin"))) {
                if (input.equals("exit")) {
                    try {
                        sout.close();
                    }
                    catch (Exception iNames) {}
                } else if (input.equals("save")) {
                    this.getBluePrint().save();
                } else if (input.equals("tocsv")) {
                    this.toCsv = !this.toCsv;
                    sout.println("to csv file is " + this.toCsv);
                } else if (input.indexOf("filename") != -1) {
                    this.exportToFileName = input.substring(input.indexOf(" ")).trim();
                    sout.println("Exporting to file:" + this.exportToFileName);
                } else if (!input.equals("")) {
                    if (this.toCsv) {
                        if (this.exportToFileName != null) {
                            try {
                                PrintStream o = new PrintStream(new File(this.exportToFileName));
                                this.executeSql(inputString.toString(), o);
                                o.close();
                            }
                            catch (Exception err) {
                                err.printStackTrace();
                            }
                        } else {
                            try {
                                String fName = "export-" + System.currentTimeMillis() + ".csv";
                                PrintStream o = new PrintStream(new File(fName));
                                this.executeSql(inputString.toString(), o);
                                o.close();
                                sout.println("Exported to file " + fName);
                            }
                            catch (Exception err) {
                                err.printStackTrace();
                            }
                        }
                    } else {
                        this.executeSql(inputString.toString(), sout);
                    }
                }
            }
        }
        sout.println();
    }

    public void executeSql(String sql, PrintStream out) {
        JDBCResultSet rs = new JDBCResultSet(sql);
        try {
            int count = 0;
            JDBCServer.execute(rs, this);
            boolean isFirst = true;
            int loc = rs.getFields().size() - 1;
            int totalWidth = 0;
            for (XSQLColumn c : rs.getFields()) {
                if (isFirst) {
                    isFirst = false;
                    if (this.toCsv) {
                        out.print("\"");
                    }
                }
                if (!this.toCsv) {
                    out.print("|");
                }
                out.print(c.getName());
                if (!this.toCsv) {
                    int cw = c.getCharWidth();
                    int cnw = c.getName().length();
                    if (cnw > cw) {
                        c.setCharWidth(cnw);
                    }
                    int gap = cw - cnw;
                    for (int i = 0; i < gap; ++i) {
                        out.print(" ");
                    }
                }
                totalWidth += c.getCharWidth() + 1;
                if (loc > 0 && this.toCsv) {
                    out.print("\",\"");
                }
                --loc;
            }
            if (this.toCsv) {
                out.println("\"");
            } else {
                ++totalWidth;
                out.println("|");
                for (int i = 0; i < totalWidth; ++i) {
                    out.print("-");
                }
                out.println();
            }
            while (rs.next()) {
                isFirst = true;
                loc = rs.getFields().size() - 1;
                for (XSQLColumn c : rs.getFields()) {
                    Object sValue;
                    if (isFirst) {
                        isFirst = false;
                        if (this.toCsv) {
                            out.print("\"");
                        }
                    }
                    if (!this.toCsv) {
                        out.print("|");
                    }
                    if ((sValue = rs.getObject(c.toString())) == null) {
                        sValue = "";
                    }
                    out.print(sValue);
                    int cw = c.getCharWidth();
                    int vw = sValue.toString().length();
                    int gap = cw - vw;
                    for (int i = 0; i < gap; ++i) {
                        out.print(" ");
                    }
                    if (loc > 0 && this.toCsv) {
                        out.print("\",\"");
                    }
                    --loc;
                }
                if (this.toCsv) {
                    out.println("\"");
                } else {
                    out.println("|");
                }
                ++count;
            }
            out.println("Total Number Of Records=" + count);
        }
        catch (Exception err) {
            err.printStackTrace(out);
        }
    }

    private class TelnetConnection
    extends Thread {
        private Socket socket = null;
        private InputStream in = null;
        private PrintStream out = null;
        private final Module currentModule = null;

        public TelnetConnection(Socket s) {
            this.socket = s;
            try {
                this.in = s.getInputStream();
                this.out = new PrintStream(s.getOutputStream());
                this.start();
            }
            catch (Exception err) {
                XSQLAdapter.log(err);
            }
        }

        @Override
        public void run() {
            StringBuffer inputString = new StringBuffer();
            String prompt = "XSQL>";
            try {
                while (!XSQLAdapter.this.stopped) {
                    if (this.currentModule != null) {
                        prompt = "XQL/" + this.currentModule.getName() + ">";
                    }
                    this.out.print(prompt);
                    char c = '\u0000';
                    byte[] data = new byte[1];
                    while (!this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && c != '\n') {
                        try {
                            this.in.read(data);
                            c = (char)data[0];
                            inputString.append(c);
                        }
                        catch (Exception err) {
                            err.printStackTrace(this.out);
                            XSQLAdapter.this.stopped = true;
                            break;
                        }
                    }
                    XSQLAdapter.this.processCommand(inputString, this.out);
                    inputString = new StringBuffer();
                }
            }
            catch (Exception err) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class NETask
    implements Runnable {
        private final JDBCResultSet rs;
        private final NormalizedNode<?, ?> modelRoot;
        private final XSQLBluePrintNode main;
        private final XSQLBluePrint bluePrint;

        public NETask(JDBCResultSet _rs, NormalizedNode<?, ?> _modelRoot, XSQLBluePrintNode _main, XSQLBluePrint _bluePrint) {
            this.rs = _rs;
            this.modelRoot = _modelRoot;
            this.main = _main;
            this.bluePrint = _bluePrint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.rs.addRecords(this.modelRoot, this.main, true, this.main.getBluePrintNodeName(), this.bluePrint);
            JDBCResultSet jDBCResultSet = this.rs;
            synchronized (jDBCResultSet) {
                --this.rs.numberOfTasks;
                if (this.rs.numberOfTasks == 0) {
                    this.rs.setFinished(true);
                    this.rs.notifyAll();
                }
            }
        }
    }
}

