/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.xsql;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLColumn;

@Deprecated
public class XSQLCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] operators = new String[]{" and ", " or ", ">=", "<=", "!=", "=", ">", "<", "like", "is null", "not null", "skip"};
    private static final String STRING_CHAR = "'";
    public static final int OP_CODE_AND = 0;
    public static final int OP_CODE_OR = 1;
    public static final int OP_CODE_GTEQ = 2;
    public static final int OP_CODE_LTEQ = 3;
    public static final int OP_CODE_NOT_EQ = 4;
    public static final int OP_CODE_EQUAL = 5;
    public static final int OP_CODE_GT = 6;
    public static final int OP_CODE_LT = 7;
    public static final int OP_CODE_LIKE = 8;
    public static final int OP_CODE_NULL = 9;
    public static final int OP_CODE_NOT_NULL = 10;
    public static final int OP_CODE_SKIP = 11;
    private XSQLCriteria left = null;
    private XSQLCriteria right = null;
    private int operation = -1;
    private Object leftValue = null;
    private Object rightValue = null;
    private String criteria = null;
    private static final Map<Class<?>, Map<String, Method>> methodCache = new ConcurrentHashMap();

    public XSQLCriteria(String data, int parentOperation) {
        this.criteria = data;
        this.parse(data, parentOperation);
    }

    private void parse(String data, int parentOperation) {
        int index1 = (data = data.trim()).indexOf("(");
        if (index1 != -1) {
            String leftCondition = data.substring(0, index1).trim();
            if (leftCondition.trim().equals("")) {
                int index2 = data.lastIndexOf(")");
                if (index2 < data.length() - 1) {
                    String rtValue = data.substring(index2 + 1).trim();
                    if (!rtValue.equals("")) {
                        this.left = new XSQLCriteria(data.substring(index1 + 1, index2), parentOperation);
                        data = data.substring(index2 + 1);
                    } else {
                        data = data.substring(1, index2);
                    }
                } else {
                    data = data.substring(1, index2);
                }
            } else {
                this.right = new XSQLCriteria(data.substring(index1 + 1, data.length() - 1), parentOperation);
                data = data.substring(0, index1);
            }
        }
        for (int i = 0; i < operators.length; ++i) {
            index1 = data.indexOf(operators[i]);
            if (index1 == -1) continue;
            this.operation = i;
            if (this.left == null) {
                this.left = new XSQLCriteria(data.substring(0, index1), this.operation);
            }
            if (this.left.leftValue != null && this.left.rightValue == null && this.left.right == null) {
                this.leftValue = this.left.leftValue;
                this.left = null;
            }
            if (this.right == null) {
                this.right = new XSQLCriteria(data.substring(index1 + operators[i].length()), this.operation);
            }
            if (this.right.leftValue != null && this.right.rightValue == null && this.right.right == null) {
                this.rightValue = this.right.leftValue;
                this.right = null;
            }
            return;
        }
        if (data.startsWith(STRING_CHAR) && data.endsWith(STRING_CHAR)) {
            data = data.substring(1, data.length() - 1);
        }
        if (parentOperation == 8 && data.startsWith("%") && data.endsWith("%") && data.substring(1, data.length() - 1).indexOf("%") == -1) {
            data = data.substring(1, data.length() - 1);
        }
        this.leftValue = data;
    }

    public static Object getValue(Object element, String propertyName) {
        try {
            Method m;
            Map<String, Method> cache = methodCache.get(element.getClass());
            if (cache == null) {
                cache = new ConcurrentHashMap<String, Method>();
                methodCache.put(element.getClass(), cache);
            }
            if ((m = cache.get(propertyName)) == null) {
                Method[] methods;
                for (Method mm : methods = element.getClass().getMethods()) {
                    if (!mm.getName().equals(propertyName) && !mm.getName().equals("get" + propertyName) && !mm.getName().equals("is" + propertyName)) continue;
                    m = mm;
                    m.setAccessible(true);
                    cache.put(propertyName, m);
                    break;
                }
            }
            Object value = null;
            if (m == null) {
                return null;
            }
            if (m.getParameterTypes() == null || m.getParameterTypes().length == 0) {
                value = m.invoke(element, null);
            } else {
                if (String.class.isAssignableFrom(m.getParameterTypes()[0])) {
                    return null;
                }
                Object arg = m.getParameterTypes()[0].newInstance();
                value = m.invoke(element, arg);
            }
            return value;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    public int isObjectFitCriteria(Object element, String propertyName) {
        Object value = XSQLCriteria.getValue(element, propertyName);
        if (value != null) {
            value = value.toString();
        }
        return this.checkValue(value);
    }

    public int checkValue(Object value) {
        if (this.leftValue != null && this.rightValue != null) {
            Object aSide = null;
            Object bSide = null;
            aSide = this.leftValue.equals("?") ? value : this.leftValue;
            bSide = this.rightValue.equals("?") ? value : this.rightValue;
            if (this.operation != 11 && this.operation != 9) {
                if (aSide == null && bSide != null) {
                    return 0;
                }
                if (aSide != null && bSide == null) {
                    return 0;
                }
                if (aSide == null && bSide == null) {
                    return 1;
                }
            }
            switch (this.operation) {
                case 5: {
                    if (aSide.equals(bSide)) {
                        return 1;
                    }
                    return 0;
                }
                case 4: {
                    if (!aSide.equals(bSide)) {
                        return 1;
                    }
                    return 0;
                }
                case 8: {
                    if (aSide.toString().indexOf(bSide.toString()) != -1) {
                        return 1;
                    }
                    return 0;
                }
                case 9: {
                    if (aSide == null) {
                        return 1;
                    }
                    return 0;
                }
                case 10: {
                    if (aSide != null) {
                        return 1;
                    }
                    return 0;
                }
                case 6: {
                    if (aSide == null || bSide == null) {
                        return 0;
                    }
                    if (Double.parseDouble(aSide.toString().trim()) > Double.parseDouble(bSide.toString().trim())) {
                        return 1;
                    }
                    return 0;
                }
                case 2: {
                    if (aSide == null || bSide == null) {
                        return 0;
                    }
                    if (Double.parseDouble(aSide.toString().trim()) >= Double.parseDouble(bSide.toString().trim())) {
                        return 1;
                    }
                    return 0;
                }
                case 7: {
                    if (aSide == null || bSide == null) {
                        return 0;
                    }
                    if (Double.parseDouble(aSide.toString().trim()) < Double.parseDouble(bSide.toString().trim())) {
                        return 1;
                    }
                    return 0;
                }
                case 3: {
                    if (aSide == null || bSide == null) {
                        return 0;
                    }
                    if (Double.parseDouble(aSide.toString().trim()) <= Double.parseDouble(bSide.toString().trim())) {
                        return 1;
                    }
                    return 0;
                }
            }
        }
        int leftResult = 0;
        if (this.left != null) {
            leftResult = this.left.checkValue(value);
        }
        int rightResult = 0;
        if (this.right != null) {
            rightResult = this.right.checkValue(value);
        }
        if (this.operation == 11) {
            if (rightResult == 0) {
                return 2;
            }
            return 3;
        }
        if (this.operation == 0) {
            if (leftResult == 0) {
                return 0;
            }
            if (rightResult == 0) {
                return 0;
            }
            if (leftResult >= 2) {
                return leftResult;
            }
            if (rightResult >= 2) {
                return rightResult;
            }
            return 1;
        }
        if (this.operation == 1) {
            if (leftResult == 0 && rightResult == 0) {
                return 0;
            }
            if (leftResult >= 2) {
                return leftResult;
            }
            if (rightResult >= 2) {
                return rightResult;
            }
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.criteria;
    }

    public String getCriteriaForProperty(XSQLColumn col) {
        StringBuffer result = new StringBuffer();
        if (this.criteria == null) {
            return "";
        }
        if (this.leftValue != null && this.rightValue != null) {
            if (this.leftValue.toString().toLowerCase().equals(col.getName().toLowerCase()) || this.leftValue.toString().toLowerCase().equals(col.toString().toLowerCase())) {
                result.append("? ").append(operators[this.operation]).append(" ").append(this.rightValue);
            } else if (this.rightValue.toString().toLowerCase().equals(col.getName().toLowerCase()) || this.rightValue.toString().toLowerCase().equals(col.toString().toLowerCase())) {
                result.append("? ").append(operators[this.operation]).append(" ").append(this.leftValue);
            }
            return result.toString();
        }
        if (this.left != null && this.right != null) {
            String leftString = this.left.getCriteriaForProperty(col);
            String rightString = this.right.getCriteriaForProperty(col);
            if (!leftString.equals("") && !rightString.equals("")) {
                return leftString + " " + operators[this.operation] + " " + rightString;
            }
            if (!leftString.equals("")) {
                return leftString;
            }
            if (!rightString.equals("")) {
                return rightString;
            }
            return "";
        }
        if (this.leftValue != null && this.leftValue.toString().toLowerCase().equals(col.toString().toLowerCase()) && this.right != null) {
            return "? " + operators[this.operation] + " (" + this.right.getCriteriaForProperty(col) + ")";
        }
        if (this.rightValue != null && this.rightValue.toString().toLowerCase().equals(col.toString().toLowerCase()) && this.left != null) {
            return "(" + this.left.getCriteriaForProperty(col) + ") " + operators[this.operation] + " ?";
        }
        return "";
    }

    public static void main(String[] args) {
        XSQLCriteria p = new XSQLCriteria("ip like '%101%' or (354>=0 or 456>=3)", -1);
        System.out.println(p.checkValue("192.268.4.4"));
        p = new XSQLCriteria("? like '%267%'", -1);
        System.out.println(p.checkValue("192.268.4.4"));
    }
}

