/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.xsql;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLAdapter;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLBluePrint;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLBluePrintNode;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.DerivedTypes;

@Deprecated
public class XSQLODLUtils {
    private static Map<Class<?>, Class<?>> types = new ConcurrentHashMap();
    public static Map<String, Field> refFieldsCache;

    public static boolean isColumnType(Class<?> cls) {
        return types.containsKey(cls);
    }

    public static String getTableName(Object odlNode) {
        if (odlNode instanceof Module) {
            return ((Module)odlNode).getNamespace().toString();
        }
        if (odlNode instanceof DataSchemaNode) {
            SchemaPath p = ((DataSchemaNode)odlNode).getPath();
            return XSQLODLUtils.extractTableName(p);
        }
        boolean bl = false;
        return null;
    }

    public static String extractTableName(SchemaPath path) {
        List lst = path.getPath();
        StringBuffer name = new StringBuffer();
        int i = 0;
        for (QName q : lst) {
            name.append(q.getLocalName());
            if (++i >= lst.size()) continue;
            name.append("/");
        }
        return name.toString();
    }

    public static String getBluePrintName(Object odlNode) {
        if (odlNode instanceof Module) {
            return ((Module)odlNode).getNamespace().toString();
        }
        if (odlNode instanceof DataSchemaNode) {
            SchemaPath p = ((DataSchemaNode)odlNode).getPath();
            return XSQLODLUtils.extractTableName(p);
        }
        return null;
    }

    public static String getODLNodeName(Object odlNode) {
        if (odlNode instanceof Module) {
            return ((Module)odlNode).getNamespace().toString();
        }
        if (odlNode instanceof DataSchemaNode) {
            SchemaPath p = ((DataSchemaNode)odlNode).getPath();
            List lst = p.getPath();
            return ((QName)lst.get(lst.size() - 1)).toString();
        }
        return null;
    }

    public static List<QName> getPath(Object odlNode) {
        return ((DataSchemaNode)odlNode).getPath().getPath();
    }

    public static String getODLTableName(Object odlNode) {
        if (odlNode instanceof Module) {
            return ((Module)odlNode).getNamespace().toString();
        }
        if (odlNode instanceof DataSchemaNode) {
            return ((DataSchemaNode)odlNode).getPath().toString();
        }
        return null;
    }

    public static String getNodeNameFromDSN(Object o) {
        DataSchemaNode node = (DataSchemaNode)o;
        String nodeName = node.getQName().toString();
        int index = nodeName.lastIndexOf(")");
        return nodeName.substring(index + 1);
    }

    public static boolean isModule(Object o) {
        return o instanceof Module;
    }

    public static boolean createOpenDaylightCache(XSQLBluePrint bluePrint, Module module) {
        XSQLBluePrintNode node = new XSQLBluePrintNode(module, 0, null);
        bluePrint.addToBluePrintCache(node, null);
        XSQLODLUtils.collectODL(bluePrint, node, module.getChildNodes(), 1);
        return true;
    }

    private static void collectODL(XSQLBluePrint bluePrint, XSQLBluePrintNode parent, Collection<DataSchemaNode> nodes, int level) {
        if (nodes == null) {
            return;
        }
        for (DataSchemaNode n : nodes) {
            if (n instanceof DataNodeContainer) {
                Set s;
                XSQLBluePrintNode bn = new XSQLBluePrintNode(n, level, parent);
                bn = bluePrint.addToBluePrintCache(bn, parent);
                if (n instanceof ListSchemaNode) {
                    XSQLODLUtils.collectODL(bluePrint, bn, ((ListSchemaNode)n).getChildNodes(), ++level);
                    s = ((ListSchemaNode)n).getAvailableAugmentations();
                    if (s != null) {
                        for (AugmentationSchema as : s) {
                            XSQLODLUtils.collectODL(bluePrint, bn, as.getChildNodes(), level);
                        }
                    }
                    --level;
                    continue;
                }
                XSQLODLUtils.collectODL(bluePrint, bn, ((DataNodeContainer)n).getChildNodes(), ++level);
                if (n instanceof ContainerSchemaNode && (s = ((ContainerSchemaNode)n).getAvailableAugmentations()) != null) {
                    for (AugmentationSchema as : s) {
                        XSQLODLUtils.collectODL(bluePrint, bn, as.getChildNodes(), level);
                    }
                }
                --level;
                continue;
            }
            if (parent != null) {
                parent.addColumn(n, parent.getParent().getBluePrintNodeName());
                continue;
            }
            XSQLAdapter.log("NO Parent!");
        }
    }

    public static Field findField(Class<?> c, String name) {
        if (c == null) {
            return null;
        }
        String cacheKey = c.getName() + name;
        Field f = refFieldsCache.get(cacheKey);
        if (f != null) {
            return f;
        }
        try {
            f = c.getDeclaredField(name);
            f.setAccessible(true);
            refFieldsCache.put(cacheKey, f);
            return f;
        }
        catch (Exception exception) {
            Class<?> s = c.getSuperclass();
            if (s != null) {
                f = XSQLODLUtils.findField(s, name);
                if (f != null) {
                    refFieldsCache.put(cacheKey, f);
                }
                return f;
            }
            return null;
        }
    }

    private static Object get(Object o, String name) {
        try {
            Class<?> c = o.getClass();
            Field f = XSQLODLUtils.findField(c, name);
            return f.get(o);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<Object> getMChildren(Object o) {
        Map<?, ?> children = XSQLODLUtils.getChildren(o);
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object val : children.values()) {
            result.add(val);
        }
        return result;
    }

    public static Map<?, ?> getChildren(Object o) {
        return (Map)XSQLODLUtils.get(o, "children");
    }

    public static Collection<?> getChildrenCollection(Object o) {
        Object value = XSQLODLUtils.get(o, "children");
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Map) {
            return ((Map)value).values();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        XSQLAdapter.log("Unknown Child Value Type=" + value.getClass().getName());
        return new ArrayList();
    }

    public static Object getValue(Object o) {
        return XSQLODLUtils.get(o, "value");
    }

    public static String getNodeIdentiofier(Object o) {
        try {
            return ((YangInstanceIdentifier.PathArgument)XSQLODLUtils.get(o, "nodeIdentifier")).getNodeType().toString();
        }
        catch (Exception err) {
            return null;
        }
    }

    public static String getNodeName(Object o) {
        Object nodeID = XSQLODLUtils.get(o, "nodeIdentifier");
        if (nodeID != null) {
            String nodeName = nodeID.toString();
            int index = nodeName.lastIndexOf(")");
            return nodeName.substring(index + 1);
        }
        return "NULL";
    }

    public static Class<?> getTypeForODLColumn(Object odlNode) {
        Object o = XSQLODLUtils.get(odlNode, "type");
        if (o instanceof TypeDefinition) {
            TypeDefinition type = (TypeDefinition)o;
            if (DerivedTypes.isUint32((TypeDefinition)type) || DerivedTypes.isUint64((TypeDefinition)type)) {
                return Long.TYPE;
            }
            if (DerivedTypes.isUint16((TypeDefinition)type)) {
                return Integer.TYPE;
            }
            if (DerivedTypes.isUint8((TypeDefinition)type)) {
                return Byte.TYPE;
            }
        }
        return String.class;
    }

    static {
        types.put(QName.class, QName.class);
        types.put(SchemaPath.class, SchemaPath.class);
        types.put(Status.class, Status.class);
        refFieldsCache = new HashMap<String, Field>();
    }
}

