/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.xsql;

import java.util.LinkedList;

@Deprecated
public class XSQLThreadPool {
    private LinkedList<Runnable> tasks = new LinkedList();
    private int threadCount = 0;
    private int maxThreadCount = 10;
    private String threadPoolName = "Simple Thread Pool";
    private int waitTimeForIdle = 10000;
    private int maxQueueSize = -1;
    public Object waitForSlotSync = new Object();

    public XSQLThreadPool(int _maxThreadCount, String name, int _waitTimeForIdle) {
        this.maxThreadCount = _maxThreadCount;
        this.threadPoolName = name;
        this.waitTimeForIdle = _waitTimeForIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable r) {
        LinkedList<Runnable> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(r);
            this.tasks.notifyAll();
            if (this.threadCount < this.maxThreadCount) {
                ++this.threadCount;
                new WorkerThread(this.threadCount).start();
            }
        }
    }

    public int getNumberOfThreads() {
        return this.threadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSlot() {
        if (this.tasks.size() > this.maxQueueSize) {
            Object object = this.waitForSlotSync;
            synchronized (object) {
                try {
                    this.waitForSlotSync.wait();
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.threadCount == 0;
    }

    public void setMaxQueueSize(int size) {
        this.maxQueueSize = size;
    }

    private class WorkerThread
    extends Thread {
        private long lastTimeExecuted;

        public WorkerThread(int threadNumber) {
            super("Thread #" + threadNumber + " Of Threadpool " + XSQLThreadPool.this.threadPoolName);
            this.lastTimeExecuted = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Runnable runthis = null;
            do {
                runthis = null;
                if (XSQLThreadPool.this.maxQueueSize != -1) {
                    object = XSQLThreadPool.this.waitForSlotSync;
                    synchronized (object) {
                        if (XSQLThreadPool.this.tasks.size() < XSQLThreadPool.this.maxQueueSize) {
                            XSQLThreadPool.this.waitForSlotSync.notifyAll();
                        }
                    }
                }
                object = XSQLThreadPool.this.tasks;
                synchronized (object) {
                    if (XSQLThreadPool.this.tasks.isEmpty()) {
                        try {
                            XSQLThreadPool.this.tasks.wait(2000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!XSQLThreadPool.this.tasks.isEmpty()) {
                        runthis = (Runnable)XSQLThreadPool.this.tasks.removeFirst();
                    }
                }
                if (runthis == null) continue;
                try {
                    runthis.run();
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
                this.lastTimeExecuted = System.currentTimeMillis();
            } while (System.currentTimeMillis() - this.lastTimeExecuted <= (long)XSQLThreadPool.this.waitTimeForIdle);
            object = XSQLThreadPool.this.tasks;
            synchronized (object) {
                XSQLThreadPool.this.threadCount--;
            }
        }
    }
}

