/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.xsql.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLAdapter;
import org.opendaylight.controller.md.sal.dom.xsql.XSQLBluePrint;
import org.opendaylight.controller.md.sal.dom.xsql.jdbc.JDBCCommand;
import org.opendaylight.controller.md.sal.dom.xsql.jdbc.JDBCResultSet;
import org.opendaylight.controller.md.sal.dom.xsql.jdbc.JDBCServer;
import org.opendaylight.controller.md.sal.dom.xsql.jdbc.JDBCStatement;

@Deprecated
public class JDBCConnection
implements Connection,
Runnable {
    private Socket socket = null;
    private DataInputStream in = null;
    private DataOutputStream out = null;
    private LinkedList<byte[]> queue = new LinkedList();
    private XSQLAdapter adapter = null;
    private XSQLBluePrint metaData = null;
    private String addr = null;
    private boolean wasClosed = false;

    public JDBCConnection(Socket s, XSQLAdapter _a) {
        this.socket = s;
        this.adapter = _a;
        try {
            this.in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            new JDBCObjectReader();
            new Thread(this).start();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public Connection getProxy() {
        return this;
    }

    public JDBCConnection(String _addr) throws Exception {
        this.addr = _addr;
        this.init();
    }

    private void init() throws Exception {
        if (this.addr.startsWith("http://")) {
            this.addr = this.addr.substring(7);
        }
        System.err.print("Address is:" + this.addr);
        this.socket = new Socket(this.addr, 40004);
        try {
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            new JDBCObjectReader();
            new Thread(this).start();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public JDBCConnection(boolean server) {
        try (ServerSocket s = new ServerSocket(50003);){
            this.socket = s.accept();
            try {
                this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                new JDBCObjectReader();
                new Thread(this).start();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private boolean isStopped() {
        if (this.adapter != null && this.adapter.stopped) {
            return true;
        }
        return this.socket == null || this.socket.isClosed();
    }

    @Override
    public void run() {
        byte[] data = null;
        while (!this.isStopped()) {
            try {
                int len = this.in.readInt();
                data = new byte[len];
                this.in.readFully(data);
                this.addObject(data);
            }
            catch (Exception err) {
                System.out.println("Connection Lost or Closed.");
                try {
                    this.out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.out = null;
                try {
                    this.in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.in = null;
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.socket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObject(byte[] data) {
        LinkedList<byte[]> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(data);
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCommand(JDBCCommand cmd) {
        switch (cmd.getType()) {
            case 7: {
                this.metaData = cmd.getBluePrint();
                JDBCConnection jDBCConnection = this;
                synchronized (jDBCConnection) {
                    this.notifyAll();
                    break;
                }
            }
            case 6: {
                this.send(new JDBCCommand(this.adapter.getBluePrint()));
                break;
            }
            case 1: {
                try {
                    JDBCServer.execute(cmd.getRS(), this.adapter);
                    this.send(new JDBCCommand(cmd.getRS(), 2));
                    QueryUpdater u = new QueryUpdater(cmd.getRS());
                    new Thread(u).start();
                }
                catch (Exception err) {
                    this.send(new JDBCCommand(err, cmd.getRSID()));
                }
                break;
            }
            case 2: {
                JDBCResultSet rs1 = JDBCStatement.getQuery(cmd.getRS().getID());
                rs1.updateData(cmd.getRS());
                break;
            }
            case 3: {
                JDBCResultSet rs2 = JDBCStatement.getQuery(cmd.getRSID());
                rs2.addRecord(cmd.getRecord());
                break;
            }
            case 4: {
                JDBCResultSet rs3 = JDBCStatement.removeQuery(cmd.getRSID());
                rs3.setFinished(true);
                break;
            }
            case 5: {
                System.err.println("ERROR Executing Query\n");
                cmd.getERROR().printStackTrace();
                JDBCResultSet rs4 = JDBCStatement.removeQuery(cmd.getRSID());
                rs4.setError(cmd.getERROR());
                rs4.setFinished(true);
                JDBCResultSet jDBCResultSet = rs4;
                synchronized (jDBCResultSet) {
                    rs4.notifyAll();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Object o) {
        if (this.socket == null) {
            try {
                this.init();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(o);
            byte[] data = bout.toByteArray();
            Socket socket = this.socket;
            synchronized (socket) {
                this.out.writeInt(data.length);
                this.out.write(data);
                this.out.flush();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        this.wasClosed = true;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new JDBCStatement(this).getProxy();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new JDBCStatement(this).getProxy();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new JDBCStatement(this).getProxy();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            JDBCCommand cmd = new JDBCCommand();
            cmd.setType(6);
            JDBCConnection jDBCConnection = this;
            synchronized (jDBCConnection) {
                this.send(cmd);
                try {
                    this.wait();
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        }
        return this.metaData;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        System.err.println("SQL 1=" + sql);
        return new JDBCStatement(this, sql).getProxy();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        System.err.println("SQL 2=" + sql);
        return new JDBCStatement(this, sql).getProxy();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        System.err.println("SQL 3=" + sql);
        return new JDBCStatement(this, sql).getProxy();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        System.err.println("SQL 4=" + sql);
        return new JDBCStatement(this, sql).getProxy();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        System.err.println("SQL 5=" + sql);
        return new JDBCStatement(this, sql).getProxy();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        System.err.println("SQL 6=" + sql);
        return new JDBCStatement(this, sql).getProxy();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    private class QueryUpdater
    implements Runnable {
        private JDBCResultSet rs = null;

        public QueryUpdater(JDBCResultSet _rs) {
            this.rs = _rs;
        }

        @Override
        public void run() {
            while (this.rs.next()) {
                JDBCCommand rec = new JDBCCommand(this.rs.getCurrent(), this.rs.getID());
                JDBCConnection.this.send(rec);
            }
            JDBCCommand end = new JDBCCommand(this.rs.getID());
            JDBCConnection.this.send(end);
        }
    }

    private class JDBCObjectReader
    extends Thread {
        public JDBCObjectReader() {
            super("JDBCObjectReader");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!JDBCConnection.this.isStopped()) {
                byte[] data = null;
                LinkedList linkedList = JDBCConnection.this.queue;
                synchronized (linkedList) {
                    if (JDBCConnection.this.queue.size() == 0) {
                        try {
                            JDBCConnection.this.queue.wait(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (JDBCConnection.this.queue.size() > 0) {
                        data = (byte[])JDBCConnection.this.queue.removeFirst();
                    }
                }
                if (data == null) continue;
                JDBCCommand command = (JDBCCommand)this.deSerialize(data);
                JDBCConnection.this.processCommand(command);
            }
        }

        private Object deSerialize(byte[] data) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                ObjectInputStream oin = new ObjectInputStream(in);
                return oin.readObject();
            }
            catch (Exception err) {
                err.printStackTrace();
                return null;
            }
        }
    }
}

