/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.md.sal.binding.DataBrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.DOMDataBrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.SchemaServiceServiceInterface;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.XSQLModuleMXBean;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="http://netconfcentral.org/ns/XSQL", name="XSQL", revision="2014-06-26")
public abstract class AbstractXSQLModule
extends AbstractModule<AbstractXSQLModule>
implements XSQLModuleMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXSQLModule.class);
    public static final JmxAttribute dataBrokerJmxAttribute = new JmxAttribute("DataBroker");
    private ObjectName dataBroker;
    public static final JmxAttribute schemaServiceJmxAttribute = new JmxAttribute("SchemaService");
    private ObjectName schemaService;
    public static final JmxAttribute asyncDataBrokerJmxAttribute = new JmxAttribute("AsyncDataBroker");
    private ObjectName asyncDataBroker;
    private DataBroker dataBrokerDependency;
    private SchemaService schemaServiceDependency;
    private DOMDataBroker asyncDataBrokerDependency;

    public AbstractXSQLModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractXSQLModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractXSQLModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        if (this.dataBroker != null) {
            this.dependencyResolver.validateDependency(DataBrokerServiceInterface.class, this.dataBroker, dataBrokerJmxAttribute);
        }
        if (this.schemaService != null) {
            this.dependencyResolver.validateDependency(SchemaServiceServiceInterface.class, this.schemaService, schemaServiceJmxAttribute);
        }
        if (this.asyncDataBroker != null) {
            this.dependencyResolver.validateDependency(DOMDataBrokerServiceInterface.class, this.asyncDataBroker, asyncDataBrokerJmxAttribute);
        }
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final DataBroker getDataBrokerDependency() {
        return this.dataBrokerDependency;
    }

    protected final SchemaService getSchemaServiceDependency() {
        return this.schemaServiceDependency;
    }

    protected final DOMDataBroker getAsyncDataBrokerDependency() {
        return this.asyncDataBrokerDependency;
    }

    protected final void resolveDependencies() {
        if (this.asyncDataBroker != null) {
            this.asyncDataBrokerDependency = (DOMDataBroker)this.dependencyResolver.resolveInstance(DOMDataBroker.class, this.asyncDataBroker, asyncDataBrokerJmxAttribute);
        }
        if (this.schemaService != null) {
            this.schemaServiceDependency = (SchemaService)this.dependencyResolver.resolveInstance(SchemaService.class, this.schemaService, schemaServiceJmxAttribute);
        }
        if (this.dataBroker != null) {
            this.dataBrokerDependency = (DataBroker)this.dependencyResolver.resolveInstance(DataBroker.class, this.dataBroker, dataBrokerJmxAttribute);
        }
    }

    public boolean canReuseInstance(AbstractXSQLModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractXSQLModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.dataBroker, other.dataBroker)) {
            return false;
        }
        if (this.dataBroker != null && !this.dependencyResolver.canReuseDependency(this.dataBroker, dataBrokerJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.schemaService, other.schemaService)) {
            return false;
        }
        if (this.schemaService != null && !this.dependencyResolver.canReuseDependency(this.schemaService, schemaServiceJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.asyncDataBroker, other.asyncDataBroker)) {
            return false;
        }
        return this.asyncDataBroker == null || this.dependencyResolver.canReuseDependency(this.asyncDataBroker, asyncDataBrokerJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractXSQLModule that = (AbstractXSQLModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getDataBroker() {
        return this.dataBroker;
    }

    @Override
    @RequireInterface(value=DataBrokerServiceInterface.class)
    public void setDataBroker(ObjectName dataBroker) {
        this.dataBroker = dataBroker;
    }

    @Override
    public ObjectName getSchemaService() {
        return this.schemaService;
    }

    @Override
    @RequireInterface(value=SchemaServiceServiceInterface.class)
    public void setSchemaService(ObjectName schemaService) {
        this.schemaService = schemaService;
    }

    @Override
    public ObjectName getAsyncDataBroker() {
        return this.asyncDataBroker;
    }

    @Override
    @RequireInterface(value=DOMDataBrokerServiceInterface.class)
    public void setAsyncDataBroker(ObjectName asyncDataBroker) {
        this.asyncDataBroker = asyncDataBroker;
    }

    public Logger getLogger() {
        return LOG;
    }
}

