/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration.XSQL;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration.xsql.AsyncDataBroker;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration.xsql.DataBroker;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.xsql.rev140626.modules.module.configuration.xsql.SchemaService;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class XSQLBuilder
implements Builder<XSQL> {
    private AsyncDataBroker _asyncDataBroker;
    private DataBroker _dataBroker;
    private SchemaService _schemaService;
    Map<Class<? extends Augmentation<XSQL>>, Augmentation<XSQL>> augmentation = Collections.emptyMap();

    public XSQLBuilder() {
    }

    public XSQLBuilder(XSQL base) {
        AugmentationHolder casted;
        this._asyncDataBroker = base.getAsyncDataBroker();
        this._dataBroker = base.getDataBroker();
        this._schemaService = base.getSchemaService();
        if (base instanceof XSQLImpl) {
            XSQLImpl impl = (XSQLImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<XSQL>>, Augmentation<XSQL>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<XSQL>>, Augmentation<XSQL>>(casted.augmentations());
        }
    }

    public AsyncDataBroker getAsyncDataBroker() {
        return this._asyncDataBroker;
    }

    public DataBroker getDataBroker() {
        return this._dataBroker;
    }

    public SchemaService getSchemaService() {
        return this._schemaService;
    }

    public <E extends Augmentation<XSQL>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public XSQLBuilder setAsyncDataBroker(AsyncDataBroker value) {
        this._asyncDataBroker = value;
        return this;
    }

    public XSQLBuilder setDataBroker(DataBroker value) {
        this._dataBroker = value;
        return this;
    }

    public XSQLBuilder setSchemaService(SchemaService value) {
        this._schemaService = value;
        return this;
    }

    public XSQLBuilder addAugmentation(Class<? extends Augmentation<XSQL>> augmentationType, Augmentation<XSQL> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<XSQL>>, Augmentation<XSQL>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public XSQLBuilder removeAugmentation(Class<? extends Augmentation<XSQL>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public XSQL build() {
        return new XSQLImpl(this);
    }

    private static final class XSQLImpl
    implements XSQL {
        private final AsyncDataBroker _asyncDataBroker;
        private final DataBroker _dataBroker;
        private final SchemaService _schemaService;
        private Map<Class<? extends Augmentation<XSQL>>, Augmentation<XSQL>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<XSQL> getImplementedInterface() {
            return XSQL.class;
        }

        private XSQLImpl(XSQLBuilder base) {
            this._asyncDataBroker = base.getAsyncDataBroker();
            this._dataBroker = base.getDataBroker();
            this._schemaService = base.getSchemaService();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<XSQL>>, Augmentation<XSQL>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<XSQL>>, Augmentation<XSQL>>(base.augmentation);
                }
            }
        }

        @Override
        public AsyncDataBroker getAsyncDataBroker() {
            return this._asyncDataBroker;
        }

        @Override
        public DataBroker getDataBroker() {
            return this._dataBroker;
        }

        @Override
        public SchemaService getSchemaService() {
            return this._schemaService;
        }

        public <E extends Augmentation<XSQL>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._asyncDataBroker);
            result = 31 * result + Objects.hashCode(this._dataBroker);
            result = 31 * result + Objects.hashCode(this._schemaService);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!XSQL.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            XSQL other = (XSQL)obj;
            if (!Objects.equals(this._asyncDataBroker, other.getAsyncDataBroker())) {
                return false;
            }
            if (!Objects.equals(this._dataBroker, other.getDataBroker())) {
                return false;
            }
            if (!Objects.equals(this._schemaService, other.getSchemaService())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                XSQLImpl otherImpl = (XSQLImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<XSQL>>, Augmentation<XSQL>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "XSQL [";
            StringBuilder builder = new StringBuilder(name);
            if (this._asyncDataBroker != null) {
                builder.append("_asyncDataBroker=");
                builder.append(this._asyncDataBroker);
                builder.append(", ");
            }
            if (this._dataBroker != null) {
                builder.append("_dataBroker=");
                builder.append(this._dataBroker);
                builder.append(", ");
            }
            if (this._schemaService != null) {
                builder.append("_schemaService=");
                builder.append(this._schemaService);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

