/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.inmemory_datastore_provider;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.inmemory_datastore_provider.InMemoryConfigDataStoreProviderModuleMXBean;
import org.opendaylight.controller.config.yang.md.sal.core.spi.config_dom_store.DOMStoreServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.SchemaServiceServiceInterface;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:inmemory-datastore-provider", name="opendaylight-inmemory-datastore-provider", revision="2014-06-17")
public abstract class AbstractInMemoryConfigDataStoreProviderModule
extends AbstractModule<AbstractInMemoryConfigDataStoreProviderModule>
implements InMemoryConfigDataStoreProviderModuleMXBean,
DOMStoreServiceInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInMemoryConfigDataStoreProviderModule.class);
    public static final JmxAttribute maxDataChangeExecutorQueueSizeJmxAttribute = new JmxAttribute("MaxDataChangeExecutorQueueSize");
    private Integer maxDataChangeExecutorQueueSize = Integer.valueOf("1000");
    public static final JmxAttribute maxDataChangeExecutorPoolSizeJmxAttribute = new JmxAttribute("MaxDataChangeExecutorPoolSize");
    private Integer maxDataChangeExecutorPoolSize = Integer.valueOf("20");
    public static final JmxAttribute maxDataChangeListenerQueueSizeJmxAttribute = new JmxAttribute("MaxDataChangeListenerQueueSize");
    private Integer maxDataChangeListenerQueueSize = Integer.valueOf("1000");
    public static final JmxAttribute debugTransactionsJmxAttribute = new JmxAttribute("DebugTransactions");
    private Boolean debugTransactions = Boolean.FALSE;
    public static final JmxAttribute maxDataStoreExecutorQueueSizeJmxAttribute = new JmxAttribute("MaxDataStoreExecutorQueueSize");
    private Integer maxDataStoreExecutorQueueSize = Integer.valueOf("5000");
    public static final JmxAttribute schemaServiceJmxAttribute = new JmxAttribute("SchemaService");
    private ObjectName schemaService;
    private SchemaService schemaServiceDependency;

    public AbstractInMemoryConfigDataStoreProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractInMemoryConfigDataStoreProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractInMemoryConfigDataStoreProviderModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        if (this.schemaService != null) {
            this.dependencyResolver.validateDependency(SchemaServiceServiceInterface.class, this.schemaService, schemaServiceJmxAttribute);
        }
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final SchemaService getSchemaServiceDependency() {
        return this.schemaServiceDependency;
    }

    protected final void resolveDependencies() {
        if (this.schemaService != null) {
            this.schemaServiceDependency = (SchemaService)this.dependencyResolver.resolveInstance(SchemaService.class, this.schemaService, schemaServiceJmxAttribute);
        }
    }

    public boolean canReuseInstance(AbstractInMemoryConfigDataStoreProviderModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractInMemoryConfigDataStoreProviderModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.maxDataChangeExecutorQueueSize, other.maxDataChangeExecutorQueueSize)) {
            return false;
        }
        if (!Objects.deepEquals(this.maxDataChangeExecutorPoolSize, other.maxDataChangeExecutorPoolSize)) {
            return false;
        }
        if (!Objects.deepEquals(this.maxDataChangeListenerQueueSize, other.maxDataChangeListenerQueueSize)) {
            return false;
        }
        if (!Objects.deepEquals(this.debugTransactions, other.debugTransactions)) {
            return false;
        }
        if (!Objects.deepEquals(this.maxDataStoreExecutorQueueSize, other.maxDataStoreExecutorQueueSize)) {
            return false;
        }
        if (!Objects.deepEquals(this.schemaService, other.schemaService)) {
            return false;
        }
        return this.schemaService == null || this.dependencyResolver.canReuseDependency(this.schemaService, schemaServiceJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractInMemoryConfigDataStoreProviderModule that = (AbstractInMemoryConfigDataStoreProviderModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public Integer getMaxDataChangeExecutorQueueSize() {
        return this.maxDataChangeExecutorQueueSize;
    }

    @Override
    @Description(value="The maximum queue size for the data change notification executor.")
    public void setMaxDataChangeExecutorQueueSize(Integer maxDataChangeExecutorQueueSize) {
        this.maxDataChangeExecutorQueueSize = maxDataChangeExecutorQueueSize;
    }

    @Override
    public Integer getMaxDataChangeExecutorPoolSize() {
        return this.maxDataChangeExecutorPoolSize;
    }

    @Override
    @Description(value="The maximum thread pool size for the data change notification executor.")
    public void setMaxDataChangeExecutorPoolSize(Integer maxDataChangeExecutorPoolSize) {
        this.maxDataChangeExecutorPoolSize = maxDataChangeExecutorPoolSize;
    }

    @Override
    public Integer getMaxDataChangeListenerQueueSize() {
        return this.maxDataChangeListenerQueueSize;
    }

    @Override
    @Description(value="The maximum queue size for the data change listeners.")
    public void setMaxDataChangeListenerQueueSize(Integer maxDataChangeListenerQueueSize) {
        this.maxDataChangeListenerQueueSize = maxDataChangeListenerQueueSize;
    }

    @Override
    public Boolean getDebugTransactions() {
        return this.debugTransactions;
    }

    @Override
    @Description(value="Enable transaction lifecycle debugging.")
    public void setDebugTransactions(Boolean debugTransactions) {
        this.debugTransactions = debugTransactions;
    }

    @Override
    public Integer getMaxDataStoreExecutorQueueSize() {
        return this.maxDataStoreExecutorQueueSize;
    }

    @Override
    @Description(value="The maximum queue size for the data store executor.")
    public void setMaxDataStoreExecutorQueueSize(Integer maxDataStoreExecutorQueueSize) {
        this.maxDataStoreExecutorQueueSize = maxDataStoreExecutorQueueSize;
    }

    @Override
    public ObjectName getSchemaService() {
        return this.schemaService;
    }

    @Override
    @RequireInterface(value=SchemaServiceServiceInterface.class)
    public void setSchemaService(ObjectName schemaService) {
        this.schemaService = schemaService;
    }

    public Logger getLogger() {
        return LOG;
    }
}

