/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.store.impl;

import com.google.common.base.Preconditions;
import org.opendaylight.controller.md.sal.dom.store.impl.ChainedTransactionCommitImpl;
import org.opendaylight.controller.md.sal.dom.store.impl.InMemoryDOMDataStore;
import org.opendaylight.controller.sal.core.spi.data.AbstractSnapshotBackedTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;

final class DOMStoreTransactionChainImpl
extends AbstractSnapshotBackedTransactionChain<String> {
    private final InMemoryDOMDataStore store;

    DOMStoreTransactionChainImpl(InMemoryDOMDataStore store) {
        this.store = (InMemoryDOMDataStore)Preconditions.checkNotNull((Object)store);
    }

    protected DOMStoreThreePhaseCommitCohort createCohort(SnapshotBackedWriteTransaction<String> tx, DataTreeModification modification) {
        return new ChainedTransactionCommitImpl(this.store, tx, modification, this);
    }

    protected DataTreeSnapshot takeSnapshot() {
        return this.store.takeSnapshot();
    }

    protected String nextTransactionIdentifier() {
        return this.store.nextIdentifier();
    }

    protected boolean getDebugTransactions() {
        return this.store.getDebugTransactions();
    }

    void transactionCommited(SnapshotBackedWriteTransaction<String> transaction) {
        super.onTransactionCommited(transaction);
    }
}

