/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.store.impl;

public class InMemoryDOMDataStoreConfigProperties {
    public static final int DEFAULT_MAX_DATA_CHANGE_EXECUTOR_QUEUE_SIZE = 1000;
    public static final int DEFAULT_MAX_DATA_CHANGE_EXECUTOR_POOL_SIZE = 20;
    public static final int DEFAULT_MAX_DATA_CHANGE_LISTENER_QUEUE_SIZE = 1000;
    public static final int DEFAULT_MAX_DATA_STORE_EXECUTOR_QUEUE_SIZE = 5000;
    private static final InMemoryDOMDataStoreConfigProperties DEFAULT = InMemoryDOMDataStoreConfigProperties.create(20, 1000, 1000, 5000);
    private final int maxDataChangeExecutorQueueSize;
    private final int maxDataChangeExecutorPoolSize;
    private final int maxDataChangeListenerQueueSize;
    private final int maxDataStoreExecutorQueueSize;

    public static InMemoryDOMDataStoreConfigProperties create(int maxDataChangeExecutorPoolSize, int maxDataChangeExecutorQueueSize, int maxDataChangeListenerQueueSize, int maxDataStoreExecutorQueueSize) {
        return new InMemoryDOMDataStoreConfigProperties(maxDataChangeExecutorPoolSize, maxDataChangeExecutorQueueSize, maxDataChangeListenerQueueSize, maxDataStoreExecutorQueueSize);
    }

    public static InMemoryDOMDataStoreConfigProperties create(int maxDataChangeExecutorPoolSize, int maxDataChangeExecutorQueueSize, int maxDataChangeListenerQueueSize) {
        return new InMemoryDOMDataStoreConfigProperties(maxDataChangeExecutorPoolSize, maxDataChangeExecutorQueueSize, maxDataChangeListenerQueueSize, 5000);
    }

    public static InMemoryDOMDataStoreConfigProperties getDefault() {
        return DEFAULT;
    }

    private InMemoryDOMDataStoreConfigProperties(int maxDataChangeExecutorPoolSize, int maxDataChangeExecutorQueueSize, int maxDataChangeListenerQueueSize, int maxDataStoreExecutorQueueSize) {
        this.maxDataChangeExecutorQueueSize = maxDataChangeExecutorQueueSize;
        this.maxDataChangeExecutorPoolSize = maxDataChangeExecutorPoolSize;
        this.maxDataChangeListenerQueueSize = maxDataChangeListenerQueueSize;
        this.maxDataStoreExecutorQueueSize = maxDataStoreExecutorQueueSize;
    }

    public int getMaxDataChangeExecutorQueueSize() {
        return this.maxDataChangeExecutorQueueSize;
    }

    public int getMaxDataChangeExecutorPoolSize() {
        return this.maxDataChangeExecutorPoolSize;
    }

    public int getMaxDataChangeListenerQueueSize() {
        return this.maxDataChangeListenerQueueSize;
    }

    public int getMaxDataStoreExecutorQueueSize() {
        return this.maxDataStoreExecutorQueueSize;
    }
}

