/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.store.impl;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration;
import org.opendaylight.controller.sal.core.spi.data.AbstractDOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.concurrent.QueuedNotificationManager;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidates;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InMemoryDOMStoreTreeChangePublisher
extends AbstractDOMStoreTreeChangePublisher {
    private static final QueuedNotificationManager.Invoker<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> MANAGER_INVOKER = new QueuedNotificationManager.Invoker<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate>(){

        public void invokeListener(AbstractDOMDataTreeChangeListenerRegistration<?> listener, DataTreeCandidate notification) {
            DOMDataTreeChangeListener inst = (DOMDataTreeChangeListener)listener.getInstance();
            if (inst != null) {
                inst.onDataTreeChanged(Collections.singletonList(notification));
            }
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMStoreTreeChangePublisher.class);
    private final QueuedNotificationManager<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> notificationManager;

    InMemoryDOMStoreTreeChangePublisher(ExecutorService listenerExecutor, int maxQueueSize) {
        this.notificationManager = new QueuedNotificationManager((Executor)listenerExecutor, MANAGER_INVOKER, maxQueueSize, "DataTreeChangeListenerQueueMgr");
    }

    protected void notifyListeners(Collection<AbstractDOMDataTreeChangeListenerRegistration<?>> registrations, YangInstanceIdentifier path, DataTreeCandidateNode node) {
        DataTreeCandidate candidate = DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)path, (DataTreeCandidateNode)node);
        for (AbstractDOMDataTreeChangeListenerRegistration<?> reg : registrations) {
            LOG.debug("Enqueueing candidate {} to registration {}", (Object)candidate, registrations);
            this.notificationManager.submitNotification(reg, (Object)candidate);
        }
    }

    protected synchronized void registrationRemoved(AbstractDOMDataTreeChangeListenerRegistration<?> registration) {
        LOG.debug("Closing registration {}", registration);
    }

    <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier treeId, L listener, DataTreeSnapshot snapshot) {
        AbstractDOMDataTreeChangeListenerRegistration reg = this.registerTreeChangeListener(treeId, listener);
        Optional node = snapshot.readNode(treeId);
        if (node.isPresent()) {
            DataTreeCandidate candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)treeId, (NormalizedNode)((NormalizedNode)node.get()));
            this.notificationManager.submitNotification((Object)reg, (Object)candidate);
        }
        return reg;
    }

    synchronized void publishChange(@Nonnull DataTreeCandidate candidate) {
        this.processCandidateTree(candidate);
    }
}

